DELIMITER $$

DROP PROCEDURE IF EXISTS V20200707213637__Insert_UITRNSForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200707213637__Insert_UITRNSForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='GUIDELINE_DOCUMENT')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','GUIDELINE_DOCUMENT','Guideline Document','Guideline Document','Riglyndokument', 'Tài liệu hướng dẫn',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='INSTRUCTIONS_GUIDELINES')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','INSTRUCTIONS_GUIDELINES','Instructions/Guidelines','Instructions/Guidelines','Instruksies / riglyne', 'Hướng dẫn / Hướng dẫn',now(),1);
 END IF;
 
END $$

-- Execute the stored procedure
CALL V20200707213637__Insert_UITRNSForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200707213637__Insert_UITRNSForPortal $$
 
DELIMITER ;