DELIMITER $$
DROP PROCEDURE IF EXISTS V20200715105429__Create_applicationOwner $$
CREATE PROCEDURE V20200715105429__Create_applicationOwner()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_owner')) THEN 
CREATE TABLE `application_owner` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `userId` BIGINT NOT NULL,
  `progBatchSeatConfigId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_application_owner_userId_idx` (`userId` ASC),
  INDEX `fk_application_owner_pbstId_idx` (`progBatchSeatConfigId` ASC),
  INDEX `fk_application_owner_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_application_owner_userId`
    FOREIGN KEY (`userId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_application_owner_pbstId`
    FOREIGN KEY (`progBatchSeatConfigId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_application_owner_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20200715105429__Create_applicationOwner () $$ 
DROP PROCEDURE IF EXISTS V20200715105429__Create_applicationOwner $$ 
DELIMITER ;