DELIMITER $$
DROP PROCEDURE IF EXISTS V20200720150554__Create_credit_note_view_sapb1 $$
CREATE PROCEDURE V20200720150554__Create_credit_note_view_sapb1()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='credit_note_view_sapb1')) THEN 
CREATE VIEW credit_note_view_sapb1 AS
    SELECT 
        bh.billNo AS CreditNoteNo,
        bh.raiseBillType AS CreditNoteType,
        but.billedUserType AS CreditNoteFor,
        c.currencyCode AS CreditNoteCurrency,
        bh.billingDate AS CreditNoteDate,
        CASE
            WHEN bh.applicantId IS NOT NULL THEN CONCAT(a.code, '/', ap.printName)
            WHEN bh.studentId IS NOT NULL THEN CONCAT(st_user.code, '/', st_user.printName)
            WHEN bh.sponsorId IS NOT NULL THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
            WHEN bh.userId IS NOT NULL THEN CONCAT(u.code, '/', u.printName)
            ELSE NULL
        END AS CreditNoteOwner,
        CONCAT(pgm.programName,
                '#',
                b.batchName,
                '#',
                seat.seatName) AS programIntakeSeatType,
        ou.code AS CreditNoteIAU,
        bh.dueDate AS DueDate,
        SUM(bfprs.billableAmount) AS Amount,
        bh.reasonForManualBill AS ReasonForManualBilling,
        fpt.feePlanType AS FeePlanType,
        fp.feePlanId AS FeePlanId,
        fpr.feeRuleDesc AS FeePlanRule,
        fsm.stageName AS FeePlanStage,
        bh.billStatus AS BillStatus,
        bh.lastUpdate AS LastUpdate
    FROM
        bill_header bh
            LEFT OUTER JOIN
        currency c ON c.id = bh.currencyId
            LEFT OUTER JOIN
        bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
            LEFT OUTER JOIN
        students st ON st.userId = bh.studentId
            LEFT OUTER JOIN
        sponsors sp ON sp.id = bh.sponsorId
            LEFT OUTER JOIN
        organization_units ou ON bh.iauId = ou.id
            LEFT OUTER JOIN
        application a ON a.id = bh.applicantId
            LEFT OUTER JOIN
        applicant_person ap ON ap.id = a.applicantPersonId
            LEFT OUTER JOIN
        users u ON u.id = bh.userId
            LEFT OUTER JOIN
        users st_user ON st_user.id = st.userId
            LEFT OUTER JOIN
        persons p ON p.id = st.personId
            LEFT OUTER JOIN
        billed_user_type but ON but.id = bh.raiseBillFor
            LEFT OUTER JOIN
        prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
            LEFT OUTER JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT OUTER JOIN
        programs pgm ON b.programId = pgm.id
            LEFT OUTER JOIN
        seat_types seat ON seat.id = pbsc.seatTypeId
            LEFT OUTER JOIN
        fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
            LEFT OUTER JOIN
        fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
            LEFT OUTER JOIN
        fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
            LEFT OUTER JOIN
        fee_plan fp ON fp.id = fpr.feePlanId
            LEFT OUTER JOIN
        fee_plan_type fpt ON fpt.id = fp.feePlanType
            LEFT OUTER JOIN
        fee_stage_master fsm ON fsm.id = fprs.stageId
    WHERE
        bh.raiseBillCategory = 'BILL_PAYABLE'
    GROUP BY bh.id;
    

END IF; 

END $$
CALL V20200720150554__Create_credit_note_view_sapb1 () $$ 
DROP PROCEDURE IF EXISTS V20200720150554__Create_credit_note_view_sapb1 $$ 
DELIMITER ;