DELIMITER $$
DROP PROCEDURE IF EXISTS V20200727131703__Create_UserReferences $$
CREATE PROCEDURE V20200727131703__Create_UserReferences()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='user_references')) THEN 
CREATE TABLE `user_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
   `employeeId` bigint(20) NOT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  `referenceName` varchar(255) DEFAULT NULL,
  `contactNo` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) DEFAULT NULL,
  `affiliation` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
 `waived` varchar(255) DEFAULT NULL,
 `remark` varchar(255) DEFAULT NULL,
 `lastUpdatedBy` bigint(20) DEFAULT NULL,
 `lastUpdate` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_user_references_lastupdatedby_idx` (`lastUpdatedBy`),
KEY `fk_user_references_employeeId_idx` (`employeeId`),
 KEY `fk_user_references_salutationId_idx` (`salutationId`),
CONSTRAINT `fk_salutationId_user_references` FOREIGN KEY (`salutationId`) REFERENCES `salutations` (`id`),
CONSTRAINT `fk_user_references_employeeId` FOREIGN KEY (`employeeId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
 CONSTRAINT `fk_lastupdatedby_user_references` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20200727131703__Create_UserReferences () $$ 
DROP PROCEDURE IF EXISTS V20200727131703__Create_UserReferences $$ 
DELIMITER ;