DELIMITER $$
DROP PROCEDURE IF EXISTS V20200729130125__Create_employeeJobPostingFormModule $$
CREATE PROCEDURE V20200729130125__Create_employeeJobPostingFormModule()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_job_posting_form_modules')) THEN 
CREATE TABLE `employee_job_posting_form_modules` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `moduleCode` VARCHAR(255) NULL,
  `moduleName` VARCHAR(255) NULL,
  `formAliasName` VARCHAR(255) NULL,
  `tableName` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_emp_form_last_updated_by_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_emp_form_last_updated_by`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP1_PERSTONAL_DETAILS', 'Personal Details', 'personalinformationform', 'persons', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP2_CONTACT_DETAILS', 'Contact Details', 'addressformwindow', 'address', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP3_EDUCATION_BACKGROUND', 'Educational Background', 'educationform', 'education_histories', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP4_WORK_EXPERIENCE', 'Work Experience', 'workexperienceform', 'work_experience', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP5_IDENTITY_DOCUMENTS', 'Identity Documents', 'identitydetailsform', 'identity_detail', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP6_OTHER_INFORMATION', 'Other Information', 'staff_other_information', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP32_NON_ACADEMIC_TOPICS', 'Non academic topics', 'facultynonacademicachievementsform', ' faculty_non_academic_achievements', now(), '1');
INSERT INTO `employee_job_posting_form_modules` (`id`, `moduleCode`, `moduleName`, `formAliasName`, `tableName`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'STEP17_REFERENCES', 'References', 'employeereferenceform', 'user_references', now(), '1');

END IF; 

END $$
CALL V20200729130125__Create_employeeJobPostingFormModule () $$ 
DROP PROCEDURE IF EXISTS V20200729130125__Create_employeeJobPostingFormModule $$ 
DELIMITER ;