DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812103010__Alter_dataRequirementSetup $$
CREATE PROCEDURE V20200812103010__Alter_dataRequirementSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' AND column_name='employee_jobPosting_id')) THEN 
ALTER TABLE `data_requirement_setup` 
ADD COLUMN `employee_jobPosting_id` BIGINT(20) NULL DEFAULT NULL AFTER `lastUpdatedBy`,
ADD INDEX `data_req_fk_emp_job_posting_idx` (`employee_jobPosting_id` ASC);
ALTER TABLE `data_requirement_setup` 
ADD CONSTRAINT `data_req_fk_emp_job_posting`
  FOREIGN KEY (`employee_jobPosting_id`)
  REFERENCES `employee_job_posting` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  END IF; 
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' AND column_name='employee_job_form_module_id')) THEN 
ALTER TABLE `data_requirement_setup` 
ADD COLUMN `employee_job_form_module_id` BIGINT(20) NULL DEFAULT NULL AFTER `employee_jobPosting_id`,
ADD INDEX `data_req_fk_job_posting_form_modules_idx` (`employee_job_form_module_id` ASC);
ALTER TABLE `data_requirement_setup` 
ADD CONSTRAINT `data_req_fk_job_posting_form_modules`
  FOREIGN KEY (`employee_job_form_module_id`)
  REFERENCES `employee_job_posting_form_modules` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
 END IF; 

END $$
CALL V20200812103010__Alter_dataRequirementSetup() $$
DROP PROCEDURE IF EXISTS V20200812103010__Alter_dataRequirementSetup $$
DELIMITER ;