DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812195352__Create_PersonRequiredDocGroupMaster $$
CREATE PROCEDURE V20200812195352__Create_PersonRequiredDocGroupMaster()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='person_required_doc_group_master')) THEN 
CREATE TABLE `person_required_doc_group_master` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `documentGroupMasterRequiredId` BIGINT(20) NOT NULL,
  `applicantPersonId` BIGINT(20) NULL,
  `personId` BIGINT(20) NULL,
  `documentId` BIGINT(20) NULL,
  `documentStatus` VARCHAR(100) NULL,
  `requestedOn` DATE NOT NULL,
  `submittedOn` DATE NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
   INDEX `fk_prdgm_dgmr_id_idx` (`documentGroupMasterRequiredId` ASC),
   INDEX `fk_prdgm_applicant_person_id_idx` (`applicantPersonId` ASC),
   INDEX `fk_prdgm_person_id_idx` (`personId` ASC),
   INDEX `fk_prdgm_document_id_idx` (`documentId` ASC),
   INDEX `fk_prdgm_user_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_prdgm_dgmr_id`
    FOREIGN KEY (documentGroupMasterRequiredId)
    REFERENCES `document_group_master_required` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_prdgm_applicant_person_id`
    FOREIGN KEY (applicantPersonId)
    REFERENCES `applicant_person` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_prdgm_person_id`
    FOREIGN KEY (personId)
    REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
 CONSTRAINT `fk_prdgm_document_id`
    FOREIGN KEY (documentId)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
 CONSTRAINT `fk_prdgm_user_id`
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200812195352__Create_PersonRequiredDocGroupMaster () $$ 
DROP PROCEDURE IF EXISTS V20200812195352__Create_PersonRequiredDocGroupMaster $$ 
DELIMITER ;