DELIMITER $$

DROP PROCEDURE IF EXISTS V20200812202345__InsertUITranslations $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200812202345__InsertUITranslations()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
 
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_SAME_AS_CURRENT_ADDRESS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','IS_SAME_AS_CURRENT_ADDRESS','Is same as Current Address','Is same as Current Address','Is dieselfde as huidige adres', 'Giống với địa chỉ hiện tại',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PARENT_COUNTRY_REGION_ID')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PARENT_COUNTRY_REGION_ID','Country Region','Country Region','Landstreek', 'Vùng quốc gia',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PIN_CODE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PIN_CODE','Pin Code','Pin Code','PIN-kode', 'Mã PIN',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='COMPANY_ADDRESS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','COMPANY_ADDRESS','Company Address','Company Address','Maatskappy Adres', 'địa chỉ công ty',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='CAPTCHA')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','CAPTCHA','Captcha','Captcha','Captcha', 'mã ngẫu nhiên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SIGNUP_ADDITIONAL_SETUP_UPDATE_SUCCESS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SIGNUP_ADDITIONAL_SETUP_UPDATE_SUCCESS','Signup additional setup added successfully','Signup additional setup added successfully','Bykomende opstelling vir aanmelding is suksesvol bygevoeg', 'Đăng ký thiết lập bổ sung đã được thêm thành công',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SIGNUP_ADDITIONAL_SETUP_ADD_SUCCESS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SIGNUP_ADDITIONAL_SETUP_ADD_SUCCESS','Signup additional setup updated successfully','Signup additional setup updated successfully','Bykomende opstelling van die aanmelding is suksesvol opgedateer', 'Đã cập nhật thiết lập bổ sung đăng ký thành công',now(),1);
END IF;
 
END $$

-- Execute the stored procedure
CALL V20200812202345__InsertUITranslations $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200812202345__InsertUITranslations $$
 
DELIMITER ;