DELIMITER $$
DROP PROCEDURE IF EXISTS V20200814120738__Create_SchoolStudiesSectionNewTable $$
CREATE PROCEDURE V20200814120738__Create_SchoolStudiesSectionNewTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='post_school_studies_section')) THEN 
CREATE TABLE `post_school_studies_section`(
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
`applicant_person_id` BIGINT(20) NULL DEFAULT NULL,
`persons_id` BIGINT(20) NULL DEFAULT NULL,
`period_from` DATE NULL DEFAULT NULL,
`period_to` DATE NULL DEFAULT NULL,
`qualification_name`  VARCHAR(255) NULL DEFAULT NULL,
`completed` BIT(1) NULL DEFAULT NULL,
`no_of_semesters_completed`  VARCHAR(100) NULL DEFAULT NULL,
`institution_name_id` BIGINT(20) NULL DEFAULT NULL,
`student_number`  VARCHAR(255) NULL DEFAULT NULL,
`remarks`  VARCHAR(255) NULL DEFAULT NULL,
`institution_status_id` BIGINT(20) NULL DEFAULT NULL,
`country_id` BIGINT(20) NULL DEFAULT NULL,
`qualification_status_id` BIGINT(20) NULL DEFAULT NULL,
`rsa_nqf_comparable_level_id` BIGINT(20) NULL DEFAULT NULL,
`overall_average_achieved`  VARCHAR(255) NULL DEFAULT NULL,
`research_module_grade`  VARCHAR(255) NULL DEFAULT NULL,
`commentary_by_assessor`  VARCHAR(255) NULL DEFAULT NULL,
`academic_transcript_verification_id` BIGINT(20) NULL DEFAULT NULL,
`degree_certificate_verification_id` BIGINT(20) NULL DEFAULT NULL,
`lastUpdatedBy` BIGINT(20) NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
   KEY `fk_school_studies_applicant_person` (`applicant_person_id`),
    KEY `fk_school_studies_persons` (`persons_id`),
	 KEY `fk_school_studies_institution_name` (`institution_name_id`),
	  KEY `fk_school_studies_institution_status` (`institution_status_id`),
	   KEY `fk_school_studies_country` (`country_id`),
	    KEY `fk_school_studies_qualification_status` (`qualification_status_id`),
	     KEY `fk_school_studies_rsa_nqf_comparable_level` (`rsa_nqf_comparable_level_id`),
	      KEY `fk_school_studies_academic_transcript_verification` (`academic_transcript_verification_id`),
	       KEY `fk_school_studies_degree_certificate_verification` (`degree_certificate_verification_id`),
	       
CONSTRAINT `fk_school_studies_applicant_person`
  FOREIGN KEY (`applicant_person_id`)
  REFERENCES `applicant_person` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,

CONSTRAINT `fk_school_studies_persons`
  FOREIGN KEY (`persons_id`)
  REFERENCES `persons` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,

CONSTRAINT `fk_school_studies_institution_name`
  FOREIGN KEY (`institution_name_id`)
  REFERENCES `institute_type` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_institution_status`
  FOREIGN KEY (`institution_status_id`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_country`
  FOREIGN KEY (`country_id`)
  REFERENCES `country` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_qualification_status`
  FOREIGN KEY (`qualification_status_id`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_rsa_nqf_comparable_level`
  FOREIGN KEY (`rsa_nqf_comparable_level_id`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_academic_transcript_verification`
  FOREIGN KEY (`academic_transcript_verification_id`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_degree_certificate_verification`
  FOREIGN KEY (`degree_certificate_verification_id`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
CONSTRAINT `fk_school_studies_degree_lastUpdatedBy` 
FOREIGN KEY (`lastUpdatedBy`) 
REFERENCES `users` (`id`)
);
END IF; 

END $$
CALL V20200814120738__Create_SchoolStudiesSectionNewTable () $$ 
DROP PROCEDURE IF EXISTS V20200814120738__Create_SchoolStudiesSectionNewTable $$ 
DELIMITER ;