DELIMITER $$
DROP PROCEDURE IF EXISTS V20200827194249__Alter_ExamBoardAddEqBoard $$
CREATE PROCEDURE V20200827194249__Alter_ExamBoardAddEqBoard()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='exam_board_master' 
		AND (column_name='equivalentExamBoardId' OR column_name='markingType'))) THEN 
		
		ALTER TABLE `exam_board_master` 
		ADD COLUMN `equivalentExamBoardId` BIGINT NULL DEFAULT NULL AFTER `itemValue`,
		ADD COLUMN `markingType` VARCHAR(20) NULL DEFAULT NULL AFTER `equivalentExamBoardId`,
		ADD CONSTRAINT `fk_exam_board_master_equivalentExamBoardId` FOREIGN KEY (`equivalentExamBoardId`) REFERENCES `exam_board_master` (`id`);
		
	END IF;
		
	SET @standardMasterId=(SELECT MAX(id) FROM standard_master where tableName='exam_board_master' AND masterName='EXAM_BOARD_MASTER');
		
	IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'equivalentExamBoardId' AND standardMasterId = @standardMasterId)) THEN 
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
		  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
		  `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1, 'equivalentExamBoardId', 'EQUIVALENT_EXAM_BOARD', @standardMasterId, 'Varchar', '3', 1, 'exam_board_master', 'id', 
		 'value', 0, 0, 1, '1', SYSDATE());
	
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'markingType' AND standardMasterId = @standardMasterId)) THEN 
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`, `diaplayOrder`,  
		  `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
		  `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1, 'markingType', 'MARKING_TYPE', @standardMasterId, 'Enum', 'MARKING_TYPE', '4', false, 0, 0,1, '1', SYSDATE());

	END IF; 

END $$

CALL V20200827194249__Alter_ExamBoardAddEqBoard() $$
DROP PROCEDURE IF EXISTS V20200827194249__Alter_ExamBoardAddEqBoard $$
DELIMITER ;
