DELIMITER $$
DROP PROCEDURE IF EXISTS V20200908192042__Update_UpdateDataProvider $$
CREATE PROCEDURE V20200908192042__Update_UpdateDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='PAYMENT_TERM_SUBMISSION_RECIPIENTS')) THEN 
update sql_dtprovider set sqlQuery = "SELECT 
    T1.id AS ID,
    T6.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    Father.`emailId` AS EMAIL_ID,
	Father.`mobileNumber` AS MOBILE_NO,
    Father.`firstName` AS PARENT_FIRSTNAME,
    Father.`lastName` AS PARENT_LASTNAME,
    Father.`mobileCountryCode` AS MOBILE_CODE,
    T8.`displayName` AS ACADEMY_NAME_LOCATION,
	T8.id AS ACADEMY_LOCATION_ID
FROM
    parent_payment_term_settings T1
        LEFT OUTER JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT OUTER JOIN
    persons T3 ON T3.id = T2.personId
        LEFT JOIN
    salutations T6 ON T6.id = T3.salutationId
        LEFT OUTER JOIN
    person_relationships T4 ON T4.personId = T3.id
        LEFT OUTER JOIN
    persons Father ON Father.id = T4.relatedPersonId
		LEFT OUTER JOIN
	admission T7 on T7.studentId = T2.userId
		LEFT OUTER JOIN
	academy_location T8 on T8.id=T7.academyLocationId
WHERE
    T4.relationship = 'FATHER' AND T1.id in (namedParams) group by T1.studentId" where dataProviderId=@dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200908192042__Update_UpdateDataProvider () $$
DROP PROCEDURE IF EXISTS V20200908192042__Update_UpdateDataProvider $$
DELIMITER ;