DELIMITER $$
DROP PROCEDURE IF EXISTS V20200910144118__Create_TermWiseAdditionalDetails $$
CREATE PROCEDURE V20200910144118__Create_TermWiseAdditionalDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_additional_setup')) THEN 
CREATE TABLE `term_wise_additional_setup` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `registrationTermSetupDetailId` bigint(20) NOT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `msgContent` blob,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_additional_setup_1_idx` (`registrationTermSetupDetailId`),
  KEY `fk_term_wise_additional_setup_2_idx` (`documentId`),
  KEY `fk_term_wise_additional_setup_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_additional_setup_1` FOREIGN KEY (`registrationTermSetupDetailId`) REFERENCES `registration_term_setup_detail` (`id`),
  CONSTRAINT `fk_term_wise_additional_setup_2` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
  CONSTRAINT `fk_term_wise_additional_setup_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

END $$
CALL V20200910144118__Create_TermWiseAdditionalDetails () $$ 
DROP PROCEDURE IF EXISTS V20200910144118__Create_TermWiseAdditionalDetails $$ 
DELIMITER ;