DELIMITER $$
DROP PROCEDURE IF EXISTS V20200923093841__Create_ProgramSubjectMappingTable $$
CREATE PROCEDURE V20200923093841__Create_ProgramSubjectMappingTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_subject_mapping' )) THEN 
CREATE TABLE `program_subject_mapping` (
  `id` BIGINT(50) NOT NULL AUTO_INCREMENT,
  `subjectId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `programId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `subjectType` BIGINT(20) NOT NULL,
  `lastUpdate` DATETIME NOT NULL,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_psm_subject_2607` (`subjectId` ASC),
  INDEX `fk_psm_user_260795` (`lastUpdatedBy` ASC),
  INDEX `fk_psm_subjecttype_260795` (`subjectType` ASC),
  INDEX `fk_psm_batch_260795` (`batchId` ASC),
  INDEX `fk_psm_program_260795` (`programId` ASC),
  INDEX `fk_psm_academylocation_260795` (`academyLocationId` ASC),
  CONSTRAINT `fk_psm_subject_260795`
    FOREIGN KEY (`subjectId`)
    REFERENCES `subjects` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_psm_academylocation_260795`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_psm_program_260795`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_psm_batch_260795`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_psm_subjecttype_260795`
    FOREIGN KEY (`subjectType`)
    REFERENCES `subject_type` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_psm_user_260795`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20200923093841__Create_ProgramSubjectMappingTable () $$ 
DROP PROCEDURE IF EXISTS V20200923093841__Create_ProgramSubjectMappingTable $$ 
DELIMITER ;