DELIMITER $$
DROP PROCEDURE IF EXISTS V20200925154757__Insert_VehicleServiceHistoryTable $$
CREATE PROCEDURE V20200925154757__Insert_VehicleServiceHistoryTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='trans_vehicle_service_history')) THEN 
CREATE TABLE `trans_vehicle_service_history` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `vehicleId` BIGINT(20) NOT NULL,
  `userId` BIGINT(20) DEFAULT NULL,
  `serviceDate` DATE NULL,
  `nextServiceDueDate` DATE NULL,
  `odometerReading` DOUBLE NULL,
  `amount` DOUBLE DEFAULT  NULL,
  `servicedBy` VARCHAR(255) NULL,
  `remark` VARCHAR(255) NULL,
 
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `trans_vsh_vehicle_idx` (`vehicleId` ASC),
  INDEX `fk_vsh_users_idx` (`lastUpdatedBy` ASC),
  INDEX `trans_vsh_user_x` (`userId` DESC),
  CONSTRAINT `trans_vsh_vehicle_id`
    FOREIGN KEY (`vehicleId`)
    REFERENCES `trans_vehicle` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
CONSTRAINT `trans_vsh_user_idx`
    FOREIGN KEY (`userId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_vsh_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200925154757__Insert_VehicleServiceHistoryTable() $$
DROP PROCEDURE IF EXISTS V20200925154757__Insert_VehicleServiceHistoryTable $$
DELIMITER ;