DELIMITER $$
DROP PROCEDURE IF EXISTS V20200928133522__Update_templateDataOfferLetter $$
CREATE PROCEDURE V20200928133522__Update_templateDataOfferLetter()
BEGIN

SET SQL_SAFE_UPDATES = 0;

IF EXISTS ((select * from `dydt_data_line_item` where `dataSourceCode` = 'OFFER_LETTER_EXPIRY_DATE')) THEN

SET @dydtDataLineItemId = (select id from `dydt_data_line_item` where `dataSourceCode` = 'OFFER_LETTER_EXPIRY_DATE');

UPDATE `dydt_data_line_item` 
SET `sqlSelectQueryDef`=
'select DATE_FORMAT(DATE_ADD(curdate(), interval pp.offerLetterAcceptDaysLimit day) ,\'%d-%m-%Y\') as offer_exp_date,
DATE_FORMAT(admissionOfferStartDate ,\'%d-%m-%Y\') as offer_letter_start_date,
DATE_FORMAT(admissionOfferEndDate ,\'%d-%m-%Y\') as offer_letter_end_date
from prog_slctn_process_admisn_conf as pp
left join program_selection_process as psp on pp.programSelectionProcessId=psp.id
left join application_program as ap on ap.progBatchSeatConfigId = psp.programBatchSeatConfigId', 
`resultColumnsDef`='offer_exp_date,offer_letter_start_date,offer_letter_end_date' 
WHERE `id` = @dydtDataLineItemId;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'offer_letter_start_date')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('offer_letter_start_date', 'Offer Letter Start Date', @dydtDataLineItemId);

END IF;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'offer_letter_end_date')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('offer_letter_end_date', 'Offer Letter End Date', @dydtDataLineItemId);

END IF;

END IF;

SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20200928133522__Update_templateDataOfferLetter() $$
DROP PROCEDURE IF EXISTS V20200928133522__Update_templateDataOfferLetter $$
DELIMITER ;