DELIMITER $$
DROP PROCEDURE IF EXISTS V20201022195941__Update_dydtBatchDetails $$
CREATE PROCEDURE V20201022195941__Update_dydtBatchDetails()
BEGIN

SET SQL_SAFE_UPDATES = 0;

IF EXISTS ((select * from `dydt_data_line_item` where `dataSourceCode` = 'BATCH_DETAILS')) THEN

SET @dydtDataLineItemId = (select id from `dydt_data_line_item` where `dataSourceCode` = 'BATCH_DETAILS');

UPDATE `dydt_data_line_item` 
SET `sqlSelectQueryDef`=
"select round(datediff(b.tillDate,b.startDate) / 365) as batch_year, 
 DATE_FORMAT(b.startDate ,'%d-%m-%Y') as batch_start_date,
 if(b.batchPartTime=1, 'Part Time', 'Full Time') as batch_study_mode,
 iy.itemValue AS batch_intake_year,
 concat(DATE_FORMAT(b.startDate,'%M %Y'),' to ',DATE_FORMAT(b.tillDate,'%M %Y'))  as batch_duration_month_year,
DATE_FORMAT(b.startDate ,'%d-%b-%Y') as batch_start_date_month_year,
DATE_FORMAT(now() ,'%d-%m-%Y') as document_print_date
 from application_program as ap
 LEFT join prog_batch_seat_config as pbsc on ap.progBatchSeatConfigId = pbsc.id
 LEFT join batches as b on pbsc.programBatchId = b.id
 LEFT JOIN intake_year iy ON b.intakeYearId=iy.id", 
`resultColumnsDef`='batch_year, batch_start_date, batch_study_mode,batch_intake_year,batch_duration_month_year,batch_start_date_month_year' 
WHERE `id` = @dydtDataLineItemId;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'batch_duration_month_year')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('batch_duration_month_year', 'Batch Duration Month Year', @dydtDataLineItemId);

END IF;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'batch_start_date_month_year')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('batch_start_date_month_year', 'Batch Start Date Month Year', @dydtDataLineItemId);

END IF;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'document_print_date')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('document_print_date', 'Document Print Date', @dydtDataLineItemId);

END IF;

END IF;

SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20201022195941__Update_dydtBatchDetails() $$
DROP PROCEDURE IF EXISTS V20201022195941__Update_dydtBatchDetails $$
DELIMITER ;