DELIMITER $$
DROP PROCEDURE IF EXISTS V20201029122512__Update_sqldtproviderCreateEnquiryFBC $$
CREATE PROCEDURE V20201029122512__Update_sqldtproviderCreateEnquiryFBC()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_ENQUIRER_DTP');
IF EXISTS ((select * from sql_dtprovider where dataProviderId = @dtproviderId)) THEN 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "select T1.`id` as ID,
T1.`firstName` as FIRST_NAME,
T1.`middleName` as MIDDLE_NAME,
T1.`lastName` as LAST_NAME,
T1.`primaryeEmailId` as EMAIL_ID,
T1.`phoneNo` as MOBILE_NO,
T1.`phoneCountryCode` AS MOBILE_CODE,
T5.displayName AS ACADEMY_NAME_LOCATION,
CONCAT(T7.addressText,' ',T8.cityName,', ',T9.countryName,', ',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
T11.printName AS LEAD_OWNER_NAME,
T13.emailId AS OWNER_EMAIL_ID,
CONCAT(T13.mobileCountryCode,' ',T13.mobileNumber) AS OWNER_MOBILE_NO,
(CASE
       WHEN
           T5.logoUrl IS NULL
               AND org.orgUrl IS NOT NULL
       THEN
           CONCAT(org.orgUrl,
                   '/',
                   'emailer/images/logo_default_image.png')
       WHEN
           T5.logoUrl IS NULL
               AND org.orgUrl IS NULL
       THEN
           'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
       ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
   END) AS LOGO_URL
from
`enquiry` T1
LEFT JOIN
academy_location T5 ON T5.id = T1.academyLocationId
LEFT JOIN
academy_location_addresses T6 ON T6.academyLocationId = T5.id
LEFT OUTER JOIN
address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
LEFT OUTER JOIN
city T8 ON T8.id = T7.cityId
LEFT OUTER JOIN
country T9 ON T9.id = T8.countryId
LEFT OUTER JOIN
country_region T10 ON T10.id = T8.countryRegionId
LEFT OUTER JOIN
users T11 ON T11.id = T1.assignedToUserId
LEFT JOIN
   staffs T12 ON T12.userId = T11.id
       LEFT JOIN
   persons T13 ON T13.id = T12.personId
LEFT OUTER JOIN
   organizations org ON org.id = (SELECT
           MAX(id)
       FROM
           organizations)
where T1.`id` IN (namedParams) group by T1.id",
    `jsonString` ='{
   "id": 1,
   "searchResultViewColumns": [
       {
           "id": 1,
           "value": "code",
           "resultKey": "ENQUIRY_CODE",
           "displayCode": "",
           "displayOrder": 0
       },
       {
           "id": 2,
           "value": "firstName",
           "resultKey": "FIRST_NAME",
           "displayCode": "",
           "displayOrder": 1
       },
       {
           "id": 3,
           "value": "Middle Name",
           "resultKey": "MIDDLE_NAME",
           "displayCode": "",
           "displayOrder": 2
       },
       {
           "id": 4,
           "value": "Last Name",
           "resultKey": "LAST_NAME",
           "displayCode": "",
           "displayOrder": 3
       },
       {
           "id": 6,
           "value": "emailId",
           "resultKey": "EMAIL_ID",
           "displayCode": "",
           "displayOrder": 5
       },
       {
           "id": 7,
           "value": "mobileNumber",
           "resultKey": "MOBILE_NO",
           "displayCode": "",
           "displayOrder": 6
       },
       {
           "id": 8,
           "value": "mobile Code",
           "resultKey": "MOBILE_CODE",
           "displayCode": "",
           "displayOrder": 7
       },
       {
           "id": 9,
           "value": "displayName",
           "resultKey": "ACADEMY_NAME_LOCATION",
           "displayCode": "",
           "displayOrder": 8
       },
       {
           "id": 10,
           "value": "Academy Location Address",
           "resultKey": "ACADEMY_LOCATION_ADDRESS",
           "displayCode": "",
           "displayOrder": 9
       },
       {
           "id": 11,
           "value": "Academy Location Phone No.",
           "resultKey": "ACADEMY_LOCATION_PHONE_NO",
           "displayCode": "",
           "displayOrder": 10
       },
       {
           "id": 12,
           "value": "Academy Location Email Id",
           "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
           "displayCode": "",
           "displayOrder": 11
       },
       {
           "id": 13,
           "value": "Lead Owner Name",
           "resultKey": "LEAD_OWNER_NAME",
           "displayCode": "",
           "displayOrder": 12
       },
       {
           "id": 14,
           "value": "Owner EmailId",
           "resultKey": "OWNER_EMAIL_ID",
           "displayCode": "",
           "displayOrder": 13
       },
       {
           "id": 15,
           "value": "Owner Mobile No",
           "resultKey": "OWNER_MOBILE_NO",
           "displayCode": "",
           "displayOrder": 14
       }
   ]
}' WHERE (`dataProviderId` = @dtproviderId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20201029122512__Update_sqldtproviderCreateEnquiryFBC () $$
DROP PROCEDURE IF EXISTS V20201029122512__Update_sqldtproviderCreateEnquiryFBC $$
DELIMITER ;