DELIMITER $$

DROP PROCEDURE IF EXISTS V20201029191005__InsertUITranForHostelChoice $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201029191005__InsertUITranForHostelChoice()

BEGIN

-- Insert new record in ui_translation table, if it doesn't already exist
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='HOSTEL_CHOICE_FIRST_PREFERENCE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','HOSTEL_CHOICE_FIRST_PREFERENCE','Hostel Choice-First Preference','Hostel Choice-First Preference', 'Koshuis-keuse-eerste voorkeur','Lựa chọn nhà trọ-Ưu tiên hàng đầu',now(),1);
END IF;

-- Insert new record in ui_translation table, if it doesn't already exist
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='HOSTEL_CHOICE_SECOND_PREFERENCE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','HOSTEL_CHOICE_SECOND_PREFERENCE','Hostel Choice-Second Preference','Hostel Choice-Second Preference', 'Koshuis-keuse-tweede voorkeur','Lựa chọn nhà trọ-Ưu tiên thứ hai',now(),1);
END IF;

-- Insert new record in ui_translation table, if it doesn't already exist
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='HOSTEL_CHOICE_THIRD_PREFERENCE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','HOSTEL_CHOICE_THIRD_PREFERENCE','Hostel Choice-Third Preference','Hostel Choice-Third Preference', 'Koshuis-keuse-derde voorkeur','Lựa chọn nhà trọ-Sở thích thứ ba',now(),1);
END IF;

END $$

-- Execute the stored procedure
CALL V20201029191005__InsertUITranForHostelChoice $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201029191005__InsertUITranForHostelChoice $$
 
DELIMITER ;