DELIMITER $$

DROP PROCEDURE IF EXISTS V20201104122010__AlterWorkExpForIndustry $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201104122010__AlterWorkExpForIndustry()

BEGIN

 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND  table_name='applicant_work_experience' 
  AND column_name= 'industry_id')) THEN

     -- ALTER TABLE QUERY;
    ALTER TABLE `applicant_work_experience` ADD COLUMN `industry_id` BIGINT(20) NULL;

	set foreign_key_checks=0;
	ALTER TABLE `applicant_work_experience` 
	ADD CONSTRAINT `applicant_work_experience_fk_industry_id`
	FOREIGN KEY (`industry_id`)
	REFERENCES `industry` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND  table_name='work_experience' 
  AND column_name= 'industry_id')) THEN

     -- ALTER TABLE QUERY;
    ALTER TABLE `work_experience` ADD COLUMN `industry_id` BIGINT(20) NULL;

	set foreign_key_checks=0;
	ALTER TABLE `work_experience` 
	ADD CONSTRAINT `work_experience_fk_industry_id`
	FOREIGN KEY (`industry_id`)
	REFERENCES `industry` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  
  END IF;
  
  -- create DFR for newly added field
   
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='workexperienceform' and `formFieldName`='industry' and `formFieldId`='industryItemId' and `formFieldInputType`='customcombobox' )) THEN 
  INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) VALUES 
 ('workexperienceform','industry','industryItemId','customcombobox',0,0,NULL,1,NOW(),'Industry','1','Work Experience','Create, Edit, and View','Industry',0);
 
 END IF;
 
 -- create translation for newly added field
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PERSON' and keyName='INDUSTRY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PERSON','INDUSTRY','Industry','Industry', 'Bedryf','Ngành công nghiệp',now(),1);
END IF;

END $$

-- Execute the stored procedure
CALL V20201104122010__AlterWorkExpForIndustry $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201104122010__AlterWorkExpForIndustry $$
 
DELIMITER ;