DELIMITER $$
DROP PROCEDURE IF EXISTS V20201106122212__Create_disciplinarySanctionDetails $$
CREATE PROCEDURE V20201106122212__Create_disciplinarySanctionDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='disciplinary_sanction_details_su')) THEN 
CREATE TABLE `disciplinary_sanction_details_su` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `disciplinaryActionId` bigint DEFAULT NULL,
  `sanctionTypeId` bigint DEFAULT NULL,
  `sanctionDate` datetime DEFAULT NULL,
  `sanctionRecallDate` datetime DEFAULT NULL,
  `serviceHours` bigint DEFAULT NULL,
  `serviceCompletionDate` datetime DEFAULT NULL,
  `whetherSanctionCompleted` bit(1) DEFAULT NULL,
  `appealOutcomeId` bigint DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sanction_disc_action_idx` (`disciplinaryActionId`),
  KEY `fk_sanction_sanction_type_idx` (`sanctionTypeId`),
  KEY `fk_sanction_appeal_outcome_idx` (`appealOutcomeId`),
  KEY `fk_sanction_type_last_update_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_sanction_appeal_outcome` FOREIGN KEY (`appealOutcomeId`) REFERENCES `appeal_outcome` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_sanction_disc_action` FOREIGN KEY (`disciplinaryActionId`) REFERENCES `disciplinary_actions_su` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_sanction_sanction_type` FOREIGN KEY (`sanctionTypeId`) REFERENCES `sanction_type` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_sanction_type_last_update` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20201106122212__Create_disciplinarySanctionDetails () $$ 
DROP PROCEDURE IF EXISTS V20201106122212__Create_disciplinarySanctionDetails $$ 
DELIMITER ;