DELIMITER $$
DROP PROCEDURE IF EXISTS V20201109211352__Create_ElectionVotingPool $$
CREATE PROCEDURE V20201109211352__Create_ElectionVotingPool()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election_voting_pool')) THEN 
CREATE TABLE `election_voting_pool` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `electionId` BIGINT(20) NOT NULL,
  `votingPool` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evp_election_id_idx` (`electionId` ASC),
  INDEX `fk_evp_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_evp_election_id`
    FOREIGN KEY (`electionId`)
    REFERENCES `election` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_evp_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20201109211352__Create_ElectionVotingPool () $$ 
DROP PROCEDURE IF EXISTS V20201109211352__Create_ElectionVotingPool $$ 
DELIMITER ;