DELIMITER $$
DROP PROCEDURE IF EXISTS V20201119190534__Create_sales_application_target_view $$
CREATE PROCEDURE V20201119190534__Create_sales_application_target_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_application_target_view')) THEN 
DROP view `sales_application_target_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_application_target_view')) THEN 
CREATE OR REPLACE view sales_application_target_view as
select managetarget.academyLocationId,managetarget.academyName,managetarget.academyCode,
managetarget.locationName,managetarget.locationCode,
managetarget.intake_year,managetarget.Target_For,sum(managetarget.Total_Target) as Total_Application_Target,
usr.printname as Staff_Owner_Name,sum(enqdata.cnt) AS Total_Actual_Application

from (
select al.id as academyLocationId,al.academyName,al.academyCode,al.locationName,locationCode
,irr.itemValue as intake_year, manageTargetType as Target_For,
manage.actualTarget as Total_Target,staffId,manage.intakeYearId
from academy_location al
left join manage_target_tertiary manage on(manage.academyLocationId=al.id and manageTargetType='APPLICATIONS')
left join intake_year ir on(manage.intakeYearId=ir.id)
left join programs prog on(prog.academyLocationId=al.id)
left join batches btc on(btc.programid=prog.id)
join intake_year irr on(btc.intakeYearId=irr.id)
group by academyName,locationCode,manageTargetType,staffId
) managetarget left join
(select
count(distinct appl.id) as cnt,appl.applicationOwner as userId,
iy.id as intakeYearId
,al.id as academyLocationId from
 application appl
 join application_program applprog on(applprog.applicationId=appl.id)
 join academy_location al on(applprog.academyLocationId=al.id)
 join programs prog on(prog.id=applprog.programId)
 join batches batch on(batch.programId=prog.id)
 join intake_year iy on(batch.intakeYearId=iy.id)
 join users usr on(usr.id=appl.applicationOwner)
group by appl.applicationOwner,
iy.id ,al.id
) enqdata

on(managetarget.intakeYearId= enqdata.intakeYearId and
managetarget.academyLocationId=enqdata.academylocationid
and managetarget.staffId=enqdata.userId)
left join users usr on(managetarget.staffId=usr.id)
group by managetarget.academyName,managetarget.locationCode,usr.id;
END IF; 

END $$
CALL V20201119190534__Create_sales_application_target_view () $$ 
DROP PROCEDURE IF EXISTS V20201119190534__Create_sales_application_target_view $$ 
DELIMITER ;