DROP procedure IF EXISTS `studentList`;

DELIMITER $$
CREATE PROCEDURE `studentList` (ids varchar(21844))
BEGIN
SELECT 
        `t1`.`userId` AS `ID`,
        `t6`.`photoUrl` AS `PERSON_IMAGE`,
        `t1`.`personId` AS `PERSON_ID`,
        `t1`.`userId` AS `APPLICATION_ID`,
        `t3`.`code` AS `ADMISSION_NUMBER`,
        `t2`.`code` AS `STUDENT_ID`,
        `t6`.`printName` AS `STUDENT_NAME`,
        `t6`.`firstName` AS `FIRST_NAME`,
        `t6`.`middleName` AS `MIDDLE_NAME`,
        `t6`.`lastName` AS `LAST_NAME`,
        `t6`.`shortName` AS `SHORT_NAME`,
        `t92`.`categoryName` AS `PROGRAM_CATEGORY`,
        `t71`.`programName` AS `PROGRAM_NAME`,
        `t71`.`id` AS `PROGRAM_ID`,
        `t70`.`batchName` AS `BATCH_NAME`,
        `t65`.`programPeriodName` AS `PROGRAM_PERIOD_NAME_NEW`,
        `t10`.`sectionCode` AS `SECTION_CODE`,
        `t93`.`itemValue` AS `INTAKE_YEAR`,
        `t6`.`emailId` AS `EMAIL_ID`,
        `t6`.`alternateEmailId` AS `ALTERNATE_EMAIL_ID`,
        `t6`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `t6`.`mobileNumber` AS `MOBILE_NUMBER`,
        `t25`.`itemValue` AS `RELIGION`,
        `t22`.`itemValue` AS `CASTE_CATEGORY`,
        `t66`.`progBatchSeatConfigId` AS `PROGRAM_BATCH_SEAT_CONFIG_ID`,
        `t3`.`id` AS `ADMISSION_ID`,
        `t70`.`id` AS `PROGRAM_BATCH_ID`,
        `t2`.`id` AS `USER_ID`,
        `t16`.`academyName` AS `ACADEMY_NAME`,
        `t16`.`locationName` AS `LOCATION_NAME`,
        `t100`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `t3`.`status` AS `ADMISSION_STATUS`,
        `t3`.`admissionDate` AS `ADMISSION_DATE`,
        `t70`.`startDate` AS `BATCH_SRART_DATE`,
        `t3`.`activeStatus` AS `STATUS`,
        `t70`.`tillDate` AS `BATCH_TILL_DATE`,
        `t6`.`birthDate` AS `DATE_OF_BIRTH`,
        `t6`.`gender` AS `GENDER`,
        `t18`.`firstName` AS `FATHERS_FULL_NAME`,
        `t18`.`firstName` AS `FATHERS_FIRST_NAME`,
        `t18`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `t18`.`lastName` AS `FATHERS_LAST_NAME`,
        `t18`.`emailId` AS `FATHERS_EMAIL_ID`,
        `t18`.`mobileNumber` AS `FATHERS_MOBILE_NUMBER`,
        `t18`.`mobileCountryCode` AS `FATHERS_MOBILE_COUNTRY_CODE`,
        `t30`.`firstName` AS `MOTHERS_FULL_NAME`,
        `t30`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `t30`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `t30`.`lastName` AS `MOTHERS_LAST_NAME`,
        `t30`.`emailId` AS `MOTHERS_EMAIL_ID`,
        `t30`.`mobileNumber` AS `MOTHERS_MOBILE_NUMBER`,
        `t21`.`firstName` AS `GUARDIAN_FULL_NAME`,
        `t30`.`mobileCountryCode` AS `MOTHERS_MOBILE_COUNTRY_CODE`,
        `t21`.`firstName` AS `GUARDIAN_FIRST_NAME`,
        `t21`.`middleName` AS `GUARDIAN_MIDDLE_NAME`,
        `t21`.`lastName` AS `GUARDIAN_LAST_NAME`,
        `t21`.`emailId` AS `GUARDIAN_EMAIL_ID`,
        `t21`.`mobileNumber` AS `GUARDIAN_MOBILE_NUMBER`,
        `t21`.`mobileCountryCode` AS `GUARDIAN_MOBILE_COUNTRY_CODE`,
        `t60`.`addressText` AS `ADDRESS`,
        `t61`.`cityName` AS `CITY_NAME`,
        `t91`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `t62`.`countryName` AS `COUNTRY_NAME`,
        `t23`.`itemValue` AS `NATIONALITY`,
        `t97`.`value` AS `HOME_LANGUAGE`,
        `t99`.`salutationName` AS `FATHERS_SALUTATION_NAME`,
        `t72`.`seatName` AS `SEAT_TYPE`,
        `t6`.`birthDate` AS `AGE`,
        `t6`.`nationalID` AS `NATIONAL_ID`,
        `t101`.`printName` AS `ADVISOR_NAME`,
        `t1`.`userId` AS `APPLICATION_CREATION_SOURCE`,
        `t102`.`salutationName` AS `GUARDIAN_SALUTATION_NAME`,
        `t98`.`salutationName` AS `MOTHERS_SALUTATION_NAME`,
        `t16`.`id` AS `ACADEMY_LOCATION_ID`,
		DATE_FORMAT(`t6`.`validTill`, "%d-%m-%Y") AS `VALID_TILL`
        
    FROM
        ((((((((((((((((((((((((((((((((((`students` `t1`
        LEFT JOIN `users` `t2` ON ((`t1`.`userId` = `t2`.`id`)))
        LEFT JOIN `persons` `t6` ON ((`t6`.`id` = `t1`.`personId`)))
        LEFT JOIN `admission` `t3` ON ((`t3`.`studentId` = `t1`.`userId`)))
        LEFT JOIN `user_academy_locations` `t15` ON (((`t2`.`id` = `t15`.`userId`)
            AND (`t15`.`whetherPrimary` = 1))))
        LEFT JOIN `person_relationships` `t20` ON (((`t6`.`id` = `t20`.`personId`)
            AND (`t20`.`relationship` = 'GUARDIAN')
            AND (`t20`.`whetherDeleted` = 0))))
        LEFT JOIN `person_relationships` `t17` ON (((`t6`.`id` = `t17`.`personId`)
            AND (`t17`.`relationship` = 'FATHER')
            AND (`t17`.`whetherDeleted` = 0))))
        LEFT JOIN `person_relationships` `t29` ON (((`t6`.`id` = `t29`.`personId`)
            AND (`t29`.`relationship` = 'MOTHER')
            AND (`t29`.`whetherDeleted` = 0))))
        LEFT JOIN `users` `t101` ON ((`t101`.`id` = `t6`.`advisorId`)))
        LEFT JOIN `student_hostel_requirement` `t100` ON (((`t100`.`personId` = `t6`.`id`)
            AND (`t100`.`whetherDeleted` = 0))))
        LEFT JOIN `nationalities` `t23` ON ((`t6`.`nationalityId` = `t23`.`id`)))
        LEFT JOIN `person_addresses` `t59` ON (((`t59`.`personId` = `t6`.`id`)
            AND (`t59`.`whetherPrimary` = 1)
            AND (`t59`.`whetherDeleted` = 0))))
        LEFT JOIN `religions` `t25` ON ((`t6`.`religionId` = `t25`.`id`)))
        LEFT JOIN `caste_categories` `t22` ON ((`t6`.`castCategoryId` = `t22`.`id`)))
        LEFT JOIN `drop_down` `t97` ON ((`t6`.`homeLanguage` = `t97`.`id`)))
        LEFT JOIN `program_batch_students` `t66` ON (((`t66`.`admissionId` = `t3`.`id`)
            AND (`t66`.`isCurrentSection` = 1)
            AND (`t66`.`isCurrentPeriod` = 1))))
        LEFT JOIN `academy_location` `t16` ON ((`t16`.`id` = `t15`.`academyLocationId`)))
        LEFT JOIN `persons` `t21` ON (((`t21`.`id` = `t20`.`relatedPersonId`)
            AND (`t20`.`relationship` = 'GUARDIAN')
            AND (`t20`.`whetherDeleted` = 0))))
        LEFT JOIN `persons` `t18` ON (((`t18`.`id` = `t17`.`relatedPersonId`)
            AND (`t17`.`relationship` = 'FATHER')
            AND (`t18`.`whetherDeleted` = 0))))
        LEFT JOIN `persons` `t30` ON (((`t30`.`id` = `t29`.`relatedPersonId`)
            AND (`t29`.`relationship` = 'MOTHER')
            AND (`t29`.`whetherDeleted` = 0))))
        LEFT JOIN `address` `t60` ON ((`t60`.`id` = `t59`.`addressId`)))
        LEFT JOIN `prog_batch_seat_config` `t74` ON ((`t74`.`id` = `t66`.`progBatchSeatConfigId`)))
        LEFT JOIN `prog_batch_period_config` `t65` ON ((`t65`.`id` = `t66`.`progBatchPeriodConfigId`)))
        LEFT JOIN `sections` `t10` ON ((`t10`.`id` = `t66`.`sectionId`)))
        LEFT JOIN `salutations` `t102` ON ((`t102`.`id` = `t21`.`salutationId`)))
        LEFT JOIN `salutations` `t99` ON ((`t99`.`id` = `t18`.`salutationId`)))
        LEFT JOIN `salutations` `t98` ON ((`t98`.`id` = `t30`.`salutationId`)))
        LEFT JOIN `city` `t61` ON ((`t61`.`id` = `t60`.`cityId`)))
        LEFT JOIN `seat_types` `t72` ON ((`t72`.`id` = `t74`.`seatTypeId`)))
        LEFT JOIN `batches` `t70` ON ((`t70`.`id` = `t65`.`programBatchId`)))
        LEFT JOIN `country` `t62` ON ((`t62`.`id` = `t61`.`countryId`)))
        LEFT JOIN `country_region` `t91` ON ((`t91`.`id` = `t61`.`countryRegionId`)))
        LEFT JOIN `programs` `t71` ON ((`t71`.`id` = `t70`.`programId`)))
        LEFT JOIN `intake_year` `t93` ON ((`t93`.`id` = `t70`.`intakeYearId`)))
        LEFT JOIN `program_category` `t92` ON ((`t92`.`id` = `t71`.`programCategoryId`)))
    WHERE
        ((`t2`.`status` = 1)
            AND (`t3`.`activeStatus` = 1)) AND FIND_IN_SET(`t2`.id,ids);
END$$

DELIMITER ;