DELIMITER $$
DROP PROCEDURE IF EXISTS V20210119170445__Insert_CommonAddProgramDataGrid $$
CREATE PROCEDURE V20210119170445__Insert_CommonAddProgramDataGrid()

BEGIN

	IF NOT EXISTS ((select * from data_grid where gridName="Academia.view.admission.applicationFormSale.AddProgramWindowGrid" and portalId=1)) THEN 
		INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
		('Academia.view.admission.applicationFormSale.AddProgramWindowGrid',1,
		'[{"id":null,"columnName":"ACADEMY","dataIndex":"academy.value","columnVisibility":"SHOW","sequence":1,"mandatory":true},
		{"id":null,"columnName":"LOCATION","dataIndex":"location.value","columnVisibility":"SHOW","sequence":2,"mandatory":true},
		{"id":null,"columnName":"PROGRAM","dataIndex":"program.value","columnVisibility":"SHOW","sequence":3,"mandatory":true},
		{"id":null,"columnName":"MODE_OF_DELIVERY","dataIndex":"modeOfDelivery.value","columnVisibility":"HIDE","sequence":4,"mandatory":false},
		{"id":null,"columnName":"REGISTRATION_TYPE","dataIndex":"batchPartTime","columnVisibility":"HIDE","sequence":5,"mandatory":false},
		{"id":null,"columnName":"BATCH","dataIndex":"batch.value","columnVisibility":"SHOW","sequence":6,"mandatory":true},
		{"id":null,"columnName":"SEAT_TYPE","dataIndex":"seatType.value","columnVisibility":"SHOW","sequence":7,"mandatory":false},
		{"id":null,"columnName":"DISTANCE_TO_TRAVEL","dataIndex":"distancetoTravel","columnVisibility":"HIDE","sequence":8,"mandatory":false},
		{"id":null,"columnName":"TRANSPORT","dataIndex":"whetherTransportApplicable","columnVisibility":"HIDE","sequence":9,"mandatory":false}]',now(),1);
	END IF; 


END $$

CALL V20210119170445__Insert_CommonAddProgramDataGrid() $$
DROP PROCEDURE IF EXISTS V20210119170445__Insert_CommonAddProgramDataGrid $$
DELIMITER ;
