DELIMITER $$
DROP PROCEDURE IF EXISTS V20210303152045__Update_StudentDocumentStatusCsm $$
CREATE PROCEDURE V20210303152045__Update_StudentDocumentStatusCsm()
BEGIN

SET FOREIGN_KEY_CHECKS=0;
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='SUBMITTED')) THEN 
	SET @idForSubmitted = (SELECT id FROM `document_status` WHERE `itemCode` ='SUBMITTED');
	UPDATE `student_documents` SET `documentStatusId` = @idForSubmitted where `status` = 'SUBMITTED' and documentStatusId is NULL;
END IF; 
	
IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='PENDING')) THEN 
	SET @idForPending = (SELECT id FROM `document_status` WHERE `itemCode` ='PENDING');
	UPDATE `student_documents` SET `documentStatusId` = @idForPending where `status` = 'PENDING' and documentStatusId is NULL;
END IF; 
	
IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='RETURNED')) THEN 
	SET @idForReturned = (SELECT id FROM `document_status` WHERE `itemCode` ='RETURNED');
	UPDATE `student_documents` SET `documentStatusId` = @idForReturned where `status` = 'RETURNED' and documentStatusId is NULL;
END IF; 
	
IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='INSPECTED')) THEN 
	SET @idForInspected = (SELECT id FROM `document_status` WHERE `itemCode` ='INSPECTED');
	UPDATE `student_documents` SET `documentStatusId` = @idForInspected where `status` = 'INSPECTED' and documentStatusId is NULL;
END IF; 
	
IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='INSPECTED_PENDING')) THEN 
	SET @idForInspectedPending = (SELECT id FROM `document_status` WHERE `itemCode` ='INSPECTED_PENDING');
	UPDATE `student_documents` SET `documentStatusId` = @idForInspectedPending where `status` = 'INSPECTED_PENDING' and documentStatusId is NULL;
END IF; 

IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='PENDING_OPTIONAL')) THEN 
	SET @idForPendingOptional = (SELECT id FROM `document_status` WHERE `itemCode` ='PENDING_OPTIONAL');
	UPDATE `student_documents` SET `documentStatusId` = @idForPendingOptional where `status` = 'PENDING_OPTIONAL' and documentStatusId is NULL;
END IF; 

IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='VERIFIED')) THEN 
	SET @idForVerified = (SELECT id FROM `document_status` WHERE `itemCode` ='VERIFIED');
	UPDATE `student_documents` SET `documentStatusId` = @idForVerified where `status` = 'VERIFIED' and documentStatusId is NULL;
END IF; 

IF EXISTS ((SELECT * FROM `document_status` WHERE `itemCode` ='INCORRECT')) THEN 
	SET @idForIncorrect = (SELECT id FROM `document_status` WHERE `itemCode` ='INCORRECT');
	UPDATE `student_documents` SET `documentStatusId` = @idForIncorrect where `status` = 'INCORRECT' and documentStatusId is NULL;
END IF; 
	
SET SQL_SAFE_UPDATES=1;	
SET FOREIGN_KEY_CHECKS=1;

END $$
CALL V20210303152045__Update_StudentDocumentStatusCsm () $$
DROP PROCEDURE IF EXISTS V20210303152045__Update_StudentDocumentStatusCsm $$
DELIMITER ;
