DELIMITER $$
DROP PROCEDURE IF EXISTS V20210309161536__Alter_AssLevelIntoConversionMaster $$
CREATE PROCEDURE V20210309161536__Alter_AssLevelIntoConversionMaster()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='conversion_master' AND column_name='assessmentLevel')) THEN 
ALTER TABLE `conversion_master` 
ADD COLUMN `assessmentLevel` varchar(255) NULL DEFAULT NULL AFTER `equivalentMarks`;
		
END IF; 

SET @standardMasterId=(SELECT MAX(id) FROM standard_master where tableName='conversion_master' AND masterName='CONVERSION_MASTER');

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'assessmentLevel' AND standardMasterId = @standardMasterId)) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@ItemsMaxId+1, 'assessmentLevel', 'ASSESSMENT_LEVEL', @standardMasterId, 'Varchar', '1', 0, 0, 0, 1, '1',SYSDATE());
END IF; 

SET SQL_SAFE_UPDATES = 0;
IF EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'grade' AND standardMasterId = @standardMasterId)) THEN 
UPDATE standard_master_items SET `diaplayOrder` = '2' WHERE dbFieldName = 'grade' AND standardMasterId = @standardMasterId;
END IF;

IF EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'equivalentMarks' AND standardMasterId = @standardMasterId)) THEN 
UPDATE standard_master_items SET `diaplayOrder` = '3' WHERE dbFieldName = 'equivalentMarks' AND standardMasterId = @standardMasterId;
END IF;
SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20210309161536__Alter_AssLevelIntoConversionMaster() $$
DROP PROCEDURE IF EXISTS V20210309161536__Alter_AssLevelIntoConversionMaster $$
DELIMITER ;