DELIMITER $$
DROP PROCEDURE IF EXISTS V20210428141129__Insert_ReportTempSOA_KRMU $$
CREATE PROCEDURE V20210428141129__Insert_ReportTempSOA_KRMU()
BEGIN

set @reportTypeId = (select max(id) from report_type where `typeName`='Student Statement of Account');
	
IF NOT EXISTS ((select * from report_template where `reportTypeId`=@reportTypeId and `templateCode`='STATEMENT_OF_ACCOUNT_KRMU')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeId, 'STATEMENT_OF_ACCOUNT_KRMU', 'Statement of Account - KRMU', 'STATEMENT_OF_ACCOUNT_KRMU.png', 'KRMU_CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'STATEMENT_OF_ACCOUNT_KRMU.jasper', 'AcademiaLogo.png');
END IF; 

set @reportTempId = (select max(id) from report_template where `reportTypeId`=@reportTypeId and `templateCode`='STATEMENT_OF_ACCOUNT_KRMU');

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='ROLL_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'ROLL_NO', 'Roll no', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='ADMISSION_YEAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'ADMISSION_YEAR', 'Admission Year', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='STUDENT_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'STUDENT_NAME', 'Student Name', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='FATHER_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'FATHER_NAME', 'Father Name', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='COURSE_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'COURSE_NAME', 'Course Name', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='CURRENT_SEMESTER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'CURRENT_SEMESTER', 'Current Semester', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='REGISTRATION_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'REGISTRATION_NO', 'Registration No', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='SESSION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'SESSION', 'Session', NOW());
END IF; 


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='MOBILE_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'MOBILE_NO', 'Mobile No', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='SCHOOL_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'SCHOOL_NAME', 'School Name', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='SERIAL_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'SERIAL_NO', 'S.No.', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='REFERENCE_TYPE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'REFERENCE_TYPE', 'Reference Type.', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='REFERENCE_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'REFERENCE_NO', 'Reference No.', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='PAYMENT_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'PAYMENT_DATE', 'Payment Date', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='SEMESTER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'SEMESTER', 'Semester', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TYPE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TYPE', 'Type', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='AMOUNT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'AMOUNT', 'Amount', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='BALANCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'BALANCE', 'Balance', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='INSTRUMENT_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'INSTRUMENT_NO', 'Instrument No.', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='INSTRUMENT_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'INSTRUMENT_DATE', 'Instrument Date', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='DRAWN_ON_BANK')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'DRAWN_ON_BANK', 'Drawn on Bank', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='REMARKS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'REMARKS', 'Remarks', NOW());
END IF;

END $$
CALL V20210428141129__Insert_ReportTempSOA_KRMU() $$
DROP PROCEDURE IF EXISTS V20210428141129__Insert_ReportTempSOA_KRMU $$
DELIMITER ;