set sql_safe_updates=0;

SET @enqDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_FOLLOWUP_REMINDER_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
		T1.id AS ID,
		T2.code AS ENQUIRY_NO,
		T5.emailId AS EMAIL_ID,
		T5.firstName AS FIRST_NAME,
		T5.lastName AS LAST_NAME,
		T5.mobileCountryCode AS MOBILE_CODE,
		T5.mobileNumber AS MOBILE_NO,
        T7.studentFirstName as PROSPECTIVE_STUDENT_FNAME,
        T7.studentLastName as PROSPECTIVE_STUDENT_LNAME,
		(Case when T6.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
		when T6.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
		else CONCAT(org.orgUrl, '/', T6.logoUrl)end) as LOGO_URL
	FROM
		enq_followup T1
			LEFT OUTER JOIN
		enquiry T2 ON T2.id = T1.enquiryId
			LEFT OUTER JOIN
		users T3 ON T3.id = T1.assignTo
			LEFT OUTER JOIN
		staffs T4 ON T4.userId = T3.id
			LEFT OUTER JOIN
		persons T5 ON T5.id = T4.personId
			LEFT OUTER JOIN
		academy_location T6 on T6.id=T2.academyLocationId
            LEFT OUTER JOIN
        enq_student_details T7 ON T7.enquiryId = T2.id
				LEFT JOIN
		organizations org on org.id = (select max(id) from organizations)
	WHERE
		T1.id IN (namedParams)",`jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "code",
            "resultKey": "ENQUIRY_NO",
            "displayCode": "",
            "displayOrder": 1
        },
		 {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "prospectiveStudentFName",
            "resultKey": "PROSPECTIVE_STUDENT_FNAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "prospectiveStudentLName",
            "resultKey": "PROSPECTIVE_STUDENT_LNAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        }
    ]
}' WHERE `dataProviderId`=@enqDtProviderId;

set sql_safe_updates=1;