DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_providerdetails //

CREATE  PROCEDURE sp_tvet_providerdetails(in p_alid varchar(1000))
BEGIN

Select loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
'' as Filler01,
concat('False Bay TVET College - ', al.displayName) as Provider_Name,
500 as Provider_Type_Id,
addr.addressText as Provider_Postal_Address_1
,ct1.cityName as Provider_Postal_Address_2,
cnt1.countryName as Provider_Postal_Address_3,
addr.pincode as Provider_Postal_Address_Code,
concat(addr.phoneAreaCode,addr.phoneNo) as Provider_Phone_Number,
'' as Provider_Fax_Number,
'' as Filler02,
usr.printName as Provider_Contact_Name,
usr.emailId as Provider_Contact_Email_Address,
concat(per.phoneAreaCode,per.phoneNo) as Provider_Contact_Phone_Number,
concat(per.mobileNumber) as Provider_Contact_Cell_Number,
'' as Filler03,
DATE_FORMAT(alpur.startDate, '%Y%m%d') as Provider_Start_Date,
case when alpur.tilldate<date(now()) then DATE_FORMAT(alpur.tillDate, '%Y%m%d') else null end as Provider_End_Date,
'' as Filler04,
4 as Provider_Class_Id,
case when alpur.tilldate>=date(now()) then '1' else '575' end as Provider_Status_Id,
1 as Province_Code,
cnt.code as Country_Code,
al.latdegree as Latitude_Degree,
al.latminute as Latitude_Minutes,
al.latseconds as Latitude_Seconds,
al.longdegree as Longitude_Degree,
al.longminute as Longitude_Minutes,
al.longseconds as Longitude_Seconds,
addr2.addressText as Provider_Physical_Address_1
,ct2.cityName as Provider_Physical_Address_2,
cnt2.countryName as Provider_Physical_Address_3,
addr2.pincode as Provider_Physical_Address_Code,
'' as Provider_Website_Address,
106 as Parent_Provider_Code,
541 as Parent_Provider_ETQE_Id,
7 as MIS_Type_Id,
case when hostlcnt.No_of_Hostels <> 0 then hostlcnt.No_of_Hostels else 0 end as No_of_Hostels,
'N' as DCS_Site_YN,
date_format(now(), '%Y%m%d') as Date_Stamp
 from academy_location al left join locations loc
on(al.locationId=loc.id) left join academy_location_addresses aladd
on(aladd.academyLocationId=al.id)
join (select add1.* from address add1 left join address_type addty1
on(add1.addressTypeId=addty1.id and addty1.addressTypeName='Correspondance' and addty1.addressCategory='ACDLOC'))
addr on(addr.id=aladd.addressId)
left join city ct1 on(addr.cityId=ct1.id)
left join country cnt1 on(addr.countryId=cnt1.id)
join academy_location_purpose alpur on(alpur.academyLocationId=al.id)
left join users usr on(usr.id=alpur.ownerId)
left join staffs staf on(usr.id=staf.userId)
left join persons per on(per.id=staf.personId)
left join address adrb on (adrb.id=aladd.addressId)
left join country_region cntr on(adrb.parentRegionId=cntr.id)
left join country cnt on(cnt.id=cntr.countryId)
left join (select add1.* from address add1 left join address_type addty1
on(add1.addressTypeId=addty1.id and addty1.addressTypeName='Current' and addty1.addressCategory='ACDLOC'))
addr2 on(addr2.id=aladd.addressId)
left join city ct2 on(addr2.cityId=ct2.id)
left join country cnt2 on(addr2.countryId=cnt2.id)
left join (select al.id,count(distinct hos.id) No_of_Hostels from academy_location al  join
resource_academy_locations resal on(resal.academylocationid=al.id)
  join
resources res on(resal.resourceId=res.id)
 join hostel hos on(res.id=hos.resourceId) group by al.id) hostlcnt
on(al.id=hostlcnt.id)  where FIND_IN_SET( al.id,p_alid)
group by al.id order by al.id;
end//
DELIMITER ;