DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_staffwbedetails //
CREATE  PROCEDURE sp_tvet_staffwbedetails(in p_alid varchar(1000))
BEGIN

select distinct usr.code as Staff_Number,'' as Unit_Standard_Id,
course.courseCode as Subject_Code  
,ptdcd.cf1 as SDL_No,
DATE_FORMAT(ptd.fromDate, '%Y%m%d') as Start_Date,
DATE_FORMAT(ptd.toDate, '%Y%m%d') as end_date,
loc.shortCode as Provider_Code ,
541 as Provider_ETQE_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
from prog_batch_course_faculty progbcf
join program_batch_course_param  progbcp on(progbcf.progBatchCourseParamId=progbcp.id)
join course_variants cv on(progbcp.courseVarientId=cv.id)
join courses course on(cv.courseId=course.id)
join staffs staf on(progbcf.facultyId=staf.userId)
join persons per on(per.id=staf.personid)
join person_training_details ptd on(per.id=ptd.personid)
join training_type trt on (trt.id=ptd.trainingTypeId and trt.itemValue='Subject Training')
join person_training_details_cd ptdcd on(ptdcd.personTrainingDetailId=ptd.id)
join users usr on(usr.id=staf.userId)
join user_academy_locations usral on(usral.userid=usr.id)
join academy_location al on(al.id=usral.academyLocationId)
join locations loc on(loc.id=al.locationId)
 where FIND_IN_SET( al.id,p_alid)

;
END//
DELIMITER ;