DELIMITER $$
DROP PROCEDURE IF EXISTS V20210604184643__Insert_HomeworkAssignmentReportTemplate $$
CREATE PROCEDURE V20210604184643__Insert_HomeworkAssignmentReportTemplate()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Assignment Reports')) THEN 
INSERT INTO `report_type` (`typeName`) VALUES ('Assignment Reports'); 
END IF; 

IF EXISTS ((select * from report_type WHERE typeName = 'Assignment Reports')) THEN 
set @assignmentId = (select max(id) from report_type WHERE typeName = 'Assignment Reports');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RANDOM_CODE_REPORT' AND reportTypeId = @assignmentId)) THEN 
update `report_template` set reportTypeId = @assignmentId, templateName = 'Assignment details' where templateCode = 'RANDOM_CODE_REPORT';
END IF;  


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT')) THEN 
set @hwassessmentId = (select id from report_type WHERE typeName = 'Assignment Reports');
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@hwassessmentId, 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT', 'GNA- Homework and Assignment Assessment Report', 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT.png', 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT_CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT.jasper', 'AcademiaLogo.png');
END IF; 

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT')) THEN 
set @gna = (select max(id) from `report_template` WHERE templateCode = 'GNA_HOMEWORK_ASSIGNMENT_ASSESSMENT_REPORT');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @gna and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@gna, 'TRANS_COURSE_NAME', 'Course :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @gna and keyValue='TRANS_COURSE_VARIANT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@gna, 'TRANS_COURSE_VARIANT', 'Course Variant :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @gna and keyValue='TRANS_FACULTY_LABEL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@gna, 'TRANS_FACULTY_LABEL', 'Faculty Mapped :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @gna and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@gna, 'TRANS_STUDENT_NAME', 'Student ID / Student Name', '1', now());
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20210604184643__Insert_HomeworkAssignmentReportTemplate() $$
DROP PROCEDURE IF EXISTS V20210604184643__Insert_HomeworkAssignmentReportTemplate $$
DELIMITER ;
