DELIMITER $$
DROP PROCEDURE IF EXISTS V20210622105011__Insert_AEIEmployeeIdCard $$
CREATE PROCEDURE V20210622105011__Insert_AEIEmployeeIdCard()
BEGIN
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'AEI_Employee_ID_Card')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('13', 'AEI_Employee_ID_Card', 'AEI Employee ID Card', 'AEI_Employee_ID_Card.png', 'CommonReport_IdCard_Vertical_AEI.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'AEI_Employee_ID_Card.jasper', 'AcademiaLogo.png');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='AEI_Employee_ID_Card'))) THEN
   
	set @employeeIDCard = (select id from report_template where templateCode ='AEI_Employee_ID_Card');
	 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@employeeIDCard, 'TRANS_STAFF_IDENTITY_CARD', 'STAFF IDENTITY CARD', '1', NOW()),
    (@employeeIDCard, 'TRANS_DOB', 'DOB:', '1', NOW()),
    (@employeeIDCard, 'TRANS_ADDRESS', 'ADDRESS:', '1', NOW()),
    (@employeeIDCard, 'TRANS_CELL', 'Cell:', '1', NOW()),
    (@employeeIDCard, 'TRANS_SECRETARY', 'SECRETARY', '1', NOW()),
    (@employeeIDCard, 'TRANS_SONOF', 'C/o.', '1', NOW()),
	 (@employeeIDCard, 'TRANS_ISUUE_DATE', 'Issue Date', '1', NOW()),
    (@employeeIDCard, 'TRANS_SIGN', '(Dr. G.VIJAYARAGAVAN)', '1', NOW());

  END IF;
END $$
CALL V20210622105011__Insert_AEIEmployeeIdCard() $$
DROP PROCEDURE IF EXISTS V20210622105011__Insert_AEIEmployeeIdCard $$
DELIMITER ;