DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708165415__Create_Program_view $$
CREATE PROCEDURE V20210708165415__Create_Program_view()
BEGIN

DROP VIEW IF EXISTS program_view;
	
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='program_view')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `program_view` AS
    SELECT 
        `prg`.`programName` AS `Name`,
        `prg`.`programCode` AS `Code`,
        `dpt`.`deptName` AS `DepartmentName`,
        `dpt`.`shortCode` AS `DepartmentCode`,
        `bch`.`batchName` AS `Batch`,
        `bch`.`startDate` AS `StartDate`,
        `bch`.`tillDate` AS `TillDate`,
        `ppt`.`typeName` AS `System`
    FROM
        (((`programs` `prg`
        JOIN `batches` `bch` ON ((`bch`.`programId` = `prg`.`id`)))
        JOIN `program_period_type` `ppt` ON ((`ppt`.`id` = `bch`.`programPeriodTypeId`)))
        JOIN `department` `dpt` ON ((`prg`.`programDepartmentId` = `dpt`.`id`)))
    WHERE
        (`prg`.`status` = 'O');


END IF; 

END $$
CALL V20210708165415__Create_Program_view () $$ 
DROP PROCEDURE IF EXISTS V20210708165415__Create_Program_view $$ 
DELIMITER ;