DELIMITER $$
DROP PROCEDURE IF EXISTS V20210805172648__Create_Fee_Quotation_Details $$
CREATE PROCEDURE V20210805172648__Create_Fee_Quotation_Details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='fee_quotation_details')) THEN 
CREATE TABLE `fee_quotation_details` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `quotationCode` VARCHAR(255) NOT NULL,
  `quotationName` VARCHAR(255) NOT NULL,
  `quotationDate` DATE NOT NULL,
  `createdBy` BIGINT NOT NULL,
  `academyLocationId` BIGINT NOT NULL,
  `approvalStatus` VARCHAR(255) NOT NULL,
  `description` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
   PRIMARY KEY (`id`),
  INDEX `fk_fee_quotation_details_to_createdBy_idx` (`createdBy`),
  INDEX `fk_fee_quotation_details_to_academy_location_idx` (`academyLocationId`),
  INDEX `fk_fee_quotation_details_to_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_fee_quotation_details_to_createdBy_idx`
    FOREIGN KEY (`createdBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_fee_quotation_details_to_academy_location_idx`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_fee_quotation_details_to_lastUpdatedBy_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 


END $$
CALL V20210805172648__Create_Fee_Quotation_Details () $$ 
DROP PROCEDURE IF EXISTS V20210805172648__Create_Fee_Quotation_Details $$ 
DELIMITER ;