DELIMITER $$
DROP PROCEDURE IF EXISTS V20210827100049__Insert_KrmuStudentBusPassAndReportType $$
CREATE PROCEDURE V20210827100049__Insert_KrmuStudentBusPassAndReportType()
BEGIN

IF NOT EXISTS ((select * from `report_type` where `typeName`='Bus Pass')) THEN 
INSERT INTO `report_type` (`typeName`) VALUES ('Bus Pass');
END IF; 

set @Bus_Pass = (select max(id) from report_type where typeName ='Bus Pass');
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KRMU_STUDENT_BUS')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( @Bus_Pass, 'KRMU_STUDENT_BUS', 'KRMU Student Pass', 'id_card_front.png', 'CommonReport_IdCard_Horizontal_ATMCardSize.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'KRMU_STUDENT_BUS.jasper', 'AcademiaLogo.png');

END IF; 

IF EXISTS ((SELECT * FROM `report_template` WHERE `templateCode`='KRMU_STUDENT_BUS')) THEN 
set @translationId = (SELECT `id` FROM `report_template` WHERE `templateCode`='KRMU_STUDENT_BUS');
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES(@translationId, 'TRANS_COURSE', 'Course', NULL, NOW()),
(@translationId, 'TRANS_VALID_UPTO', 'Valid Upto', NULL, NOW()),
(@translationId, 'TRANS_MOBILE_NO', 'Mobile No', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTIONS', 'Instructions', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_ONE', 'First Instruction', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_TWO', 'Second Instruction', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_THREE', 'Third Instruction', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_FOUR', 'Fourth Instruction', NULL, NOW()),
(@translationId, 'TRANS_UNIVERSITY_NAME', 'University Name', NULL, NOW()),
(@translationId, 'TRANS_ADDRESS', 'Address', NULL, NOW()),
(@translationId, 'TRANS_EMAIL', 'Email', NULL, NOW()),
(@translationId, 'TRANS_WEBSITE', 'Website', NULL, NOW()),
(@translationId, 'TRANS_PHONE_NO', 'Ph. No.', NULL, NOW()),
(@translationId, 'TRANS_EMAIL_ID', 'Email ID', NULL, NOW()),
(@translationId, 'TRANS_WEBSITE_NAME', 'Website Name', NULL, NOW()),
(@translationId, 'TRANS_PHONE_NO_VALUE', 'Phone Number', NULL, NOW()),
(@translationId, 'STUDENT_BUS_PASS', 'Student Bus Pass', NULL, NOW()),
(@translationId, 'TRANS_REGISTRAR_SIGNATURE', 'Registrar Signature', NULL, NOW());

END IF; 
END $$
CALL V20210827100049__Insert_KrmuStudentBusPassAndReportType() $$
DROP PROCEDURE IF EXISTS V20210827100049__Insert_KrmuStudentBusPassAndReportType $$
DELIMITER ;