DELIMITER $$
DROP PROCEDURE IF EXISTS V20211117131111__Insert_MobileAppConfigPrivilageAndSeedData $$
CREATE PROCEDURE V20211117131111__Insert_MobileAppConfigPrivilageAndSeedData()
BEGIN

IF NOT EXISTS ((select id from privilege where id=623)) THEN 
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`)
  VALUES (623, '0', 'Mobile App Config Tab', 'Mobile App Config Tab', 'MOBILE_APP_CONFIG_TAB', 'Mobile App Config Tab', 1, now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='MOBILE_APP_PORTAL')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','MOBILE_APP_PORTAL','Mobile App','Mobile App','Mobiele toepassing', 'Ứng dụng di động',now(),1);
END IF; 


-- seed data

IF NOT EXISTS ((SELECT * FROM `module_information` WHERE  moduleCode='SMA_PERSONAL_DETAILS' and portalId=(select id from portals where portalName="Student Mobile App"))) THEN 
set @portalId=(select id from portals where portalName="Student Mobile App");
INSERT INTO `module_information` (`moduleCode`,`moduleName`,`isEditable`,`portalId`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('SMA_PERSONAL_DETAILS','Personal Details',false,@portalId,now(),1);
END IF; 

IF EXISTS ((SELECT * FROM `module_information` WHERE  moduleCode='SMA_PERSONAL_DETAILS' and portalId=(select id from portals where portalName="Student Mobile App"))) THEN 
Set @moduleInformationId = (select id from module_information where moduleCode ='SMA_PERSONAL_DETAILS' and portalId = (select id from portals where portalName="Student Mobile App"));

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='form_field_information')) THEN

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='photoFileImage' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','photoFileImage','Upload Image','Upload Image',false,false,@moduleInformationId,now(),1);
END IF; 

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='salutationId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','salutationId','salutation','salutation',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='firstNameId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','firstNameId','firstName','First Name',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='middleNameId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','middleNameId','middleName','Middle Name',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='lastNameId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','lastNameId','lastName','Last Name',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='shortNameId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','shortNameId','shortName','Short Name',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='genderId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','genderId','genderCSM','Gender',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='fieldOfInterestItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','fieldOfInterestItemId','fieldOfInterest','Field of Interest',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='firstNameOtherLnguageId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","firstNameOtherLnguageId","firstNameOtherLanguage","First Name-Other Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='middleNameOtherLnguageId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","middleNameOtherLnguageId","middleNameOtherLanguage","Middle Name-Other Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='lastNameOtherLnguageId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","lastNameOtherLnguageId","lastNameOtherLanguage","Last Name-Other Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='shortNameOtherLnguageId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","shortNameOtherLnguageId","shortNameOtherLanguage","Short Name-Other Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='printNameOtherLnguageId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","printNameOtherLnguageId","printNameOtherLanguage","Print Name-Other Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='birthDateId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','birthDateId','birthDate','Date of Birth',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='birthPlaceId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','birthPlaceId','birthPlace','Place of Birth',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='birthPlaceOtherLanguageItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','birthPlaceOtherLanguageItemId','birthPlaceOtherLanguage','Place of Birth-Other Language',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='countryCombo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','countryCombo','country','Home Country',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='nationalityCombo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','nationalityCombo','nationality','Nationality',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuSecondaryCitizenshipItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','stuSecondaryCitizenshipItemId','secondaryCitizenship','Secondary Citizenship',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='sadcCitizenship' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO `form_field_information` (`formName`,`formAliasName`,`fieldId`,`fieldName`,`fieldDisplayName`,`isEditable`,`isLocked`,`moduleInformationId`,`lastUpdate`,`lastUpdatedBy`) VALUES ('Personal Details Info','personalinformationform','sadcCitizenship','sadcCitizenship','SADC Citizenship',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='admissionDate' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","admissionDate","admissionDate","Date of Admission",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='domicileCombo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","domicileCombo","domicile","Domicile",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='idTypeCombo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ('Personal Details Info','personalinformationform','idTypeCombo','idtype','ID Type',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='nationalIDItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ('Personal Details Info','personalinformationform','nationalIDItemId','nationalID','National Id',false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='examCenterCSM' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","examCenterCSM","examCenterCSM","Exam Center",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='currentActivity' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","currentActivity","currentActivity","Current Activity",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='haveDisabilities' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","haveDisabilities","haveDisabilities","Disabilities",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='currentEducationalInterventionsItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","currentEducationalInterventionsItemId","currentEducationalInterventions","Current Educational Interventions",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='areaOfResearchItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","areaOfResearchItemId","areaOfResearch","Area of Research",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='studentAttendanceGroup' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","studentAttendanceGroup","studentAttendanceGroup","Student Group",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='advisorItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","advisorItemId","advisorId","Advisor Name",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='isLearnerSACitizenField' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","isLearnerSACitizenField","isLearnerSACitizen","Is Student SA Citizen",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='isMidtermJoineeField' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","isMidtermJoineeField","isMidtermJoinee","Mid Term Joinee",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='homeLanguage' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","homeLanguage","homeLanguage","Home Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='secondLanguage' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","secondLanguage","secondLanguage","Second Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuCorrespondenceLanguageItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuCorrespondenceLanguageItemId","correspondenceLanguage","Correspondence Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuContactLanguageItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuContactLanguageItemId","contactLanguage","Contact Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuIsWheelCharRequiredItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuIsWheelCharRequiredItemId","isWheelChairRequired","Wheel Chair Required",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuPermanentResItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuPermanentResItemId","isPermanentResident","Permanent Residency",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuAsylumSeekerItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuAsylumSeekerItemId","isAsylumSeeker","Asylum seeker",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuAreYouRefugeeItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuAreYouRefugeeItemId","areYouRefugee","Are you a refugee?",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='stuIsStudyingInstitutionItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","stuIsStudyingInstitutionItemId","isTertiaryInstitution","Did you or are you currently studying at a tertiary institution",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='isMilitarySponsoredItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","isMilitarySponsoredItemId","isMilitarySponsored","Military Sponsored?",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='pHDSponsorItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","pHDSponsorItemId","pHDSponsor","PhD Sponsor",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='isBursaryRequirementsItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","isBursaryRequirementsItemId","isBursaryRequirements","Bursary Requirements",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='studentDownloadURL' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","studentDownloadURL","supportDocument","Upload Document",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='externalSysRefOne' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","externalSysRefOne","externalSysRefOne","External System Reference 1",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='externalSysRefTwo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","externalSysRefTwo","externalSysRefTwo","External System Reference 2",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='externalSysRefThree' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","externalSysRefThree","externalSysRefThree","External System Reference 3",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='phoneNoField' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","phoneNoField","phoneNo","Phone Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='mobileNumber' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","mobileNumber","mobileNumber","Mobile Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='alternateMobileNumber' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","alternateMobileNumber","alternateMobileNo","Alternate Mobile Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='emailId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","emailId","emailId","Email Id",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='alternateEmailId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","alternateEmailId","alternateEmailId","Alternate Email Id",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='boardNumberId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","boardNumberId","boardNumber","Examination Board Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='bloodGroupId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","bloodGroupId","bloodGroup","Blood Group",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='maritalStatusId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","maritalStatusId","maritalStatus","Marital Status",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='religionCombo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","religionCombo","religion","Religion",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='castCategoryCombo' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","castCategoryCombo","castCategory","Cast Category",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='categoryId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","categoryId","category","Category",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='postNumberId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","postNumberId","postNumber","Post Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='personalIncomeId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","personalIncomeId","personalIncome","Family Income",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='accountingKeyId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","accountingKeyId","accountingKey","Accounting Key",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='validTill' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","validTill","validTill","Valid Till",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='hpcsaRegNoId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","hpcsaRegNoId","hpcsaRegNo","HPCSA Registration Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='armsOfService' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","armsOfService","armsOfService","Arms Of Service",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='mustering' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","mustering","mustering","Mustering",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='employeeLanguage' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","employeeLanguage","employeeLanguage","Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='readItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","readItemId","read","Read",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='writeItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","writeItemId","write","Write",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='speakItemId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","speakItemId","speak","Speak",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='beneficiaryName' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","beneficiaryName","beneficiaryName","Beneficiary Name",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='beneficiaryNameOtherLanguageId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","beneficiaryNameOtherLanguageId","beneficiaryNameOtherLanguage","Beneficiary Name-Other Language",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='accountNumber' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","accountNumber","accountNumber","Account Number",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='accountTypeId' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","accountTypeId","accountTypeId","Account Type",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='bankName' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","bankName","bankName","Bank Name",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='branchName' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","branchName","branchName","Branch Name",false,false,@moduleInformationId,now(),1);
END IF;

IF NOT EXISTS ((SELECT id FROM `form_field_information` WHERE  formAliasName='personalinformationform' and  fieldId='ifsCode' and moduleInformationId=@moduleInformationId)) THEN 
INSERT INTO form_field_information (formName,formAliasName,fieldId,fieldName,fieldDisplayName,isEditable,isLocked,moduleInformationId,lastUpdate,lastUpdatedBy)VALUES ("Personal Details Info","personalinformationform","ifsCode","ifsCode","IFSC Code",false,false,@moduleInformationId,now(),1);
END IF;

END IF;
END IF;

END $$
CALL V20211117131111__Insert_MobileAppConfigPrivilageAndSeedData() $$
DROP PROCEDURE IF EXISTS V20211117131111__Insert_MobileAppConfigPrivilageAndSeedData $$
DELIMITER ;