DELIMITER $$
DROP PROCEDURE IF EXISTS V20211213102933__Insert_BuzzVarsityCollegeStudentIDCARD $$
CREATE PROCEDURE V20211213102933__Insert_BuzzVarsityCollegeStudentIDCARD()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD')) THEN 

INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '7', 'BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD', 'Buzz Varsity College Student ID Card', 'id_card_front.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF; 

set @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD = (select max(id) from report_template where templateCode ='BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD, 'STUDENT_NAME', 'Student Name:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='STUDENT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD, 'STUDENT_NO', 'Student No:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD, 'COURSE_CODE', 'Course Code:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD and keyValue='CAMPUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@BUZZ_VARSITY_COLLEGE_STUDENT_ID_CARD, 'CAMPUS', 'Campus:', '1', NOW());
END IF;

END $$
CALL V20211213102933__Insert_BuzzVarsityCollegeStudentIDCARD() $$
DROP PROCEDURE IF EXISTS V20211213102933__Insert_BuzzVarsityCollegeStudentIDCARD $$
DELIMITER ;