DELIMITER $$
DROP PROCEDURE IF EXISTS V20211215174206__Insert_educationhistory_newfield $$
CREATE PROCEDURE V20211215174206__Insert_educationhistory_newfield()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PERSON' and keyName='RESULT_CAPTURE_MODE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('PERSON','RESULT_CAPTURE_MODE','Result Capturing Mode','Result Capturing Mode',now(),1);
END IF; 


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='RESULT_CAPTURE_MODE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','RESULT_CAPTURE_MODE','Result Capturing Mode','Result Capturing Mode',now(),1);
END IF; 


IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE `formAliasName`='educationform' and `formFieldName`='resultCapturingMode' and  `formFieldId`='resultCapturingMode' and `formFieldInputType`='textfield')) THEN 
INSERT INTO form_field_info (formAliasName, formFieldName, formFieldId, formFieldInputType, isMandatory, isLocked, defaultValue, 
lastUpdatedBy, lastUpdate, formFieldDefaultLabel, formFieldDefaultHelpText, fieldDisplayName, formScreenName, formScreenMode) VALUES
('educationform','resultCapturingMode','resultCapturingMode','textfield',0,0,NULL,1,now(),
'Result Capturing Mode',NULL,'Result Capturing Mode','Education History','Create, Edit, and View');
END IF; 


IF EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.pasthistory.EducationHistoryGrid' and portalid=1)) THEN 
SET @dataGridId=(select id from data_grid where gridName='Academia.view.personinfo.common.pasthistory.EducationHistoryGrid' and portalid=1);
UPDATE `data_grid` SET `jsonObject` = '[\n  {\"id\":null,\"columnName\":\"EXAM_PASSED\",\"dataIndex\":\"examPassed\",\"columnVisibility\":\"SHOW\",\"sequence\":1,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"EXAM_BOARD\",\"dataIndex\":\"examBoard\",\"columnVisibility\":\"SHOW\",\"sequence\":2,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"EXAM_CONDUCTED_BY_COLLAGE\",\"dataIndex\":\"examConductedBy\",\"columnVisibility\":\"SHOW\",\"sequence\":3,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"INSTITUTE_NAME\",\"dataIndex\":\"instituteName\",\"columnVisibility\":\"SHOW\",\"sequence\":4,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"MARKS_GRADE_OBTAINED\",\"dataIndex\":\"marksOrGradeObtained\",\"columnVisibility\":\"SHOW\",\"sequence\":5,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"GPA/Percentage\",\"dataIndex\":\"percentage\",\"columnVisibility\":\"SHOW\",\"sequence\":6,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"YEAR_OF_EXAM\",\"dataIndex\":\"yearOfExamination\",\"columnVisibility\":\"SHOW\",\"sequence\":7,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"RESULT_STATUS\",\"dataIndex\":\"resultStatus\",\"columnVisibility\":\"SHOW\",\"sequence\":8,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"ENROLLMENT_NUMBER\",\"dataIndex\":\"enrollmentNumber\",\"columnVisibility\":\"SHOW\",\"sequence\":9,\"mandatory\":false},\n  {\"id\":null,\"columnName\":\"PLACE\",\"dataIndex\":\"place\",\"columnVisibility\":\"HIDE\",\"sequence\":10,\"mandatory\":false},\n\n{\"id\":null,\"columnName\":\"RESULT_CAPTURE_MODE\",\"dataIndex\":\"resultCapturingMode\",\"columnVisibility\":\"HIDE\",\"sequence\":11,\"mandatory\":false}\n  ]' WHERE `id` = @dataGridId;
END IF; 

END $$
CALL V20211215174206__Insert_educationhistory_newfield() $$
DROP PROCEDURE IF EXISTS V20211215174206__Insert_educationhistory_newfield $$
DELIMITER ;