DELIMITER $$
DROP PROCEDURE IF EXISTS V20211222141256__Create_programCatalouge $$
CREATE PROCEDURE V20211222141256__Create_programCatalouge()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_catalogue')) THEN 
CREATE TABLE `program_catalogue` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `programId` bigint NOT NULL,
  `catalogueContentId` bigint NOT NULL,
   `whetherHtml` BIT(1) NULL DEFAULT b'1',
   `content` TEXT  NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_program_catalogue_program_id` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_program_catalogue_catalogue_Content_id` FOREIGN KEY (`catalogueContentId`) REFERENCES `catalogue_content` (`id`),
  CONSTRAINT `UC_program_catalogue_catalogue_programId_and_catalogueContentId` UNIQUE (`programId`,`catalogueContentId`)
);
END IF; 

END $$
CALL V20211222141256__Create_programCatalouge () $$ 
DROP PROCEDURE IF EXISTS V20211222141256__Create_programCatalouge $$ 
DELIMITER ;