DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_subjectdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_subjectdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN

SELECT DISTINCT
    cou.courseCode AS Subject_Code,
    cou.courseName AS Subject_Name,
    CASE
        WHEN cnl.itemCode IS NULL THEN 515
        ELSE cnl.itemCode
    END AS NQF_Level_Id,
    CASE
        WHEN cec.courseCESMId IS NULL THEN 530
        ELSE cec.courseCESMId
    END AS Subfield_Id,
    CASE
        WHEN rt.itemCode IS NULL THEN 1
        ELSE rt.itemCode
    END AS AET_Level_Id,
    MIN(DATE_FORMAT(per.programPeriodStart, '%Y%m%d')) AS Subject_Reg_Start_Date,
    CASE
        WHEN per.programPeriodEnd < NOW() THEN DATE_FORMAT(per.programPeriodEnd, '%Y%m%d')
        ELSE NULL
    END AS Subject_Reg_End_Date,
    al.locationCode AS Provider_Code,
    '541' AS Provider_ETQE_Id,
    CASE
        WHEN per.programPeriodEnd < NOW() THEN 2
        ELSE 1
    END AS Subject_Status_Id,
    CASE
        WHEN CAST(FLOOR(cou.courseCredits) AS UNSIGNED) = 0 THEN 10
        ELSE CAST(FLOOR(cou.courseCredits) AS UNSIGNED)
    END AS Subject_Credit,
    DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
FROM
    program_courses pc
        LEFT JOIN
    batches b ON (pc.programBatchId = b.id
        AND b.startDate < NOW())
        LEFT JOIN
    programs p ON b.programId = p.id
        LEFT JOIN
    academy_location al ON al.id = p.academyLocationId
        LEFT JOIN
    registration_type rt ON rt.id = p.registrationTypeId
        LEFT JOIN
    affiliated_university au ON au.id = p.affiliatedUniversityId
        LEFT JOIN
    prog_batch_period_config per ON per.programBatchId = b.id
        LEFT JOIN
    courses cou ON cou.id = pc.courseId
        LEFT JOIN
    course_cesm_code cec ON cec.id = cou.courseCESMCodeId
        LEFT JOIN
    course_nqf_level cnl ON cnl.id = cou.courseNQFLevelId
WHERE
    YEAR(NOW()) BETWEEN YEAR(b.startDate) AND YEAR(b.tillDate)
        AND al.locationCode <> 'FBC' and  FIND_IN_SET( al.id,p_alid) and b.intakeYearId=intakeYearId
GROUP BY cou.courseCode , al.locationCode;


END//
DELIMITER ;