DELIMITER $$
DROP PROCEDURE IF EXISTS V20220416132302__Create_Registration_Setup_Address $$
CREATE PROCEDURE V20220416132302__Create_Registration_Setup_Address()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='registration_setup_address')) THEN 
CREATE TABLE `registration_setup_address` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `termWiseProfileLinkId` bigint NOT NULL,
  `addressCode` varchar(255) NOT NULL,
  `whetherMandatory` bit(1) NOT NULL DEFAULT b'1',
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_registration_setup_address_idx` (`termWiseProfileLinkId`),
  KEY `registration_setup_address_idx_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_registration_setup_address` FOREIGN KEY (`termWiseProfileLinkId`) REFERENCES `term_wise_profile_link` (`id`),
  CONSTRAINT `fk_registration_setup_address_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20220416132302__Create_Registration_Setup_Address () $$ 
DROP PROCEDURE IF EXISTS V20220416132302__Create_Registration_Setup_Address $$ 
DELIMITER ;