DELIMITER $$
DROP PROCEDURE IF EXISTS V20220425164241__Create_ProgramOtherDetails $$
CREATE PROCEDURE V20220425164241__Create_ProgramOtherDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_other_details')) THEN 
CREATE TABLE `program_other_details` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `programId` bigint NOT NULL,
  `programCollaborationId` bigint NULL,
  `programModeOfferingId` bigint NULL,
  `programCESMId` bigint  NULL,
  `programNqfLevelId` bigint NULL,
  `subsidyFundingId` bigint NULL,
  `subsidyFundingAddId` bigint NULL,
  `hEQSFTypeId` bigint NULL,
  `programGraduationSequence` varchar(255) NULL,
  `programHEQSFType2015`bigint NULL,
  `programAligned` BIT(1) NULL DEFAULT b'0',
  `programNQFcreditsTotal` bigint NULL,
  `programNQFcreditsResearch` bigint NULL,
  `programNQFcreditsWILEL` bigint NULL,
  `programHEMISWILELDuration` varchar(255) NULL,
  `programHEMISSubsidyunits` varchar(255) NULL,
  `programApprovalDate` date DEFAULT NULL,
  `programMinDurationTime` bigint NULL,
  `programMinExperienceTime` bigint NULL,
  `programMinFormalTime` bigint NULL,
  `programExtendedprogramme` BIT(1) NULL DEFAULT b'0',
  `programExtendedprogrammeSubsidized` BIT(1) NULL DEFAULT b'0',
  `programPQMReport` BIT(1) NULL DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_other_details_program_id` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_other_details_collaboration_id` FOREIGN KEY (`programCollaborationId`) REFERENCES `program_collaboration` (`id`),
  CONSTRAINT `fk_other_details_mode_offering_id` FOREIGN KEY (`programModeOfferingId`) REFERENCES `program_mode_offering` (`id`),
  CONSTRAINT `fk_other_details_cesm_id` FOREIGN KEY (`programCESMId`) REFERENCES `program_cesm` (`id`),
  CONSTRAINT `fk_other_details_nqf_level_id` FOREIGN KEY (`programNqfLevelId`) REFERENCES `program_nqf_level` (`id`),
  CONSTRAINT `fk_other_details_subsidy_funding_id` FOREIGN KEY (`subsidyFundingId`) REFERENCES `drop_down` (`id`),
  CONSTRAINT `fk_other_details_subsidy_funding_add_id` FOREIGN KEY (`subsidyFundingAddId`) REFERENCES `drop_down` (`id`),
  CONSTRAINT `fk_other_details_heqsft_id` FOREIGN KEY (`hEQSFTypeId`) REFERENCES `drop_down` (`id`));
END IF; 

END $$
CALL V20220425164241__Create_ProgramOtherDetails () $$ 
DROP PROCEDURE IF EXISTS V20220425164241__Create_ProgramOtherDetails $$ 
DELIMITER ;