DELIMITER $$
DROP PROCEDURE IF EXISTS V20220503154849__Create_registration_rules $$
CREATE PROCEDURE V20220503154849__Create_registration_rules()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='registration_rules')) THEN 
CREATE TABLE `registration_rules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `registrationRuleValue` varchar(255) NOT NULL,
  `registrationRuleCode` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Course Group', 'COURSE_GROUP');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Time Table Clash', 'TIME_TABLE_CLASH');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Section Capacity', 'SECTION_CAPACITY');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Minimum & Maximum No. of Modules', 'MINIMUM_MAXIMUM_NO_OF_MODULES');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Minimum & Maximum No. of Credits', 'MINIMUM_MAXIMUM_NO_OF_CREDITS');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Co-requisite', 'CO_REQUISITE');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Pre-Requisite', 'PRE_REQUISITE');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Mutually Exclusive', 'MUTUALLY_EXCLUSIVE');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Yearly Registrations Applicable', 'YEARLY_REGISTRATIONS_APPLICABLE');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Additional Modules Applicable', 'ADDITIONAL_MODULES_APPLICABLE');
INSERT INTO `registration_rules` (`registrationRuleValue`, `registrationRuleCode`) VALUES ('Force Repetition of Modules', 'FORCE_REPETITION_OF_MODULES');


END IF; 

END $$
CALL V20220503154849__Create_registration_rules () $$ 
DROP PROCEDURE IF EXISTS V20220503154849__Create_registration_rules $$ 
DELIMITER ;