DELIMITER $$
DROP PROCEDURE IF EXISTS V20220718120000__Insert_KKU_StudentIDCardTemplate $$
CREATE PROCEDURE V20220718120000__Insert_KKU_StudentIDCardTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KKU_STUDENT_ID_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('7', 'KKU_STUDENT_ID_CARD', 'KKU student ID card', 'KKU_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontal_ATMCardSize.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'KKU_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='KKU_STUDENT_ID_CARD'))) THEN
   
	set @studentIDCard = (select id from report_template where templateCode ='KKU_STUDENT_ID_CARD');
	 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@studentIDCard, 'TRANS_IDENTITY_CARD', 'Identity Card', '1', NOW()),
	(@studentIDCard, 'TRANS_STUDENTS_NAME', 'STUDENTS NAME', '1', NOW()),
    (@studentIDCard, 'TRANS_FATHERS_NAME', 'FATHERS NAME', '1', NOW()),
    (@studentIDCard, 'TRANS_MOTHERS_NAME', 'MOTHERS NAME', '1', NOW()),
    (@studentIDCard, 'TRANS_SCHOOL', 'SCHOOL', '1', NOW()),
    (@studentIDCard, 'TRANS_PROGRAMME', 'PROGRAMME', '1', NOW()),
    (@studentIDCard, 'TRANS_ENROLLMENT_NO', 'ENROLLMENT NO.', '1', NOW()),
    (@studentIDCard, 'TRANS_DOB', 'D.O.B', '1', NOW()),
    (@studentIDCard, 'TRANS_ADDRESS', 'ADDRESS', '1', NOW()),
    (@studentIDCard, 'TRANS_MOBILE_NO', 'Mob', '1', NOW()),
    (@studentIDCard, 'TRANS_BLOOD_GROUP', 'B.G', '1', NOW()),
    (@studentIDCard, 'TRANS_SESSION', 'SESSION', '1', NOW()),
    (@studentIDCard, 'TRANS_REGISTRAR', 'Registrar', '1', NOW()),
    (@studentIDCard, 'TRANS_PHONE', 'Phone', '1', NOW()),
    (@studentIDCard, 'TRANS_EMAIL_ID', 'E-mail', '1', NOW()),
    (@studentIDCard, 'TRANS_FOOTER_ADDRESS', 'Barauti, Nepura, Deepnagar (Biharsharif), Nalanda Bihar', '1', NOW()),
    (@studentIDCard, 'TRANS_FOOTER_PHONE', '1800 123 4202', '1', NOW()),
    (@studentIDCard, 'TRANS_FOOTER_EMAIL', 'info@kkuniversity.ac.in', '1', NOW());

  END IF;

END $$
CALL V20220718120000__Insert_KKU_StudentIDCardTemplate() $$
DROP PROCEDURE IF EXISTS V20220718120000__Insert_KKU_StudentIDCardTemplate $$
DELIMITER ;