DELIMITER $$
DROP PROCEDURE IF EXISTS V20221006154534__Create_DocSubmissionAppOwnerEvent $$
CREATE PROCEDURE V20221006154534__Create_DocSubmissionAppOwnerEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='DOCUMENT_SUBMISSION_APPLICATION_OWNER')) THEN
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'DOCUMENT_SUBMISSION_APPLICATION_OWNER');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='DOCUMENT_SUBMISSION_APPLICATION_OWNER');
INSERT INTO `system_msg_event`
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'DOCUMENT_SUBMISSION_APPLICATION_OWNER', 'Document Submission Application Owner', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Document Submission Application Owner');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Event

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DOCUMENT_SUBMISSION_APPLICATION_OWNER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT', 'SQL');

-- Create Recipient Type

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM application_required_documents T1 WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT');
INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT
    T3.`id` AS ID,    
    T4.`itemValue` AS DOC_SUBMISSION_APP_OWNER_DOCUMENT_NAME,
    T5.`code` AS DOC_SUBMISSION_APP_OWNER_APPLICANT_ID,
    T8.`printName` AS DOC_SUBMISSION_APP_OWNER_APPLICANT_NAME,
    (CASE
        WHEN
            T6.id IS NULL
        THEN
            T7.printName
		ELSE 
			T6.printName
    END) AS DOC_SUBMISSION_APP_OWNER_APPLICANT_OWNER,
    (CASE
        WHEN
            T6.id IS NULL
        THEN
            T7.emailId
		ELSE 
			T6.emailId
    END) AS EMAIL_ID,
	(CASE
        WHEN
            T6.id IS NULL
        THEN
            T7.firstName
		ELSE 
			T6.firstName
    END) AS FIRST_NAME,
    (CASE
        WHEN
            T6.id IS NULL
        THEN
            T7.lastName
		ELSE 
			T6.lastName
    END) AS LAST_NAME
FROM
    application_required_documents T3
LEFT OUTER JOIN
    document_types T4 ON T4.id = T3.documentTypeId
        LEFT OUTER JOIN
    application T5 ON T5.id = T3.applicationId
        LEFT OUTER JOIN
    users T6 ON T6.id = T5.applicationOwner
		LEFT OUTER JOIN
    users T7 ON T7.id = 1
        LEFT OUTER JOIN
    applicant_person T8 ON T8.id = T5.applicantPersonId
WHERE
    T3.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "itemValue",
            "resultKey": "DOC_SUBMISSION_APP_OWNER_DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "DOC_SUBMISSION_APP_OWNER_APPLICANT_ID",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "DOC_SUBMISSION_APP_OWNER_APPLICANT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "printName",
            "resultKey": "DOC_SUBMISSION_APP_OWNER_APPLICANT_OWNER",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='DOCUMENT_SUBMISSION_APPLICATION_OWNER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='DOCUMENT_SUBMISSION_APPLICATION_OWNER');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
VALUES(@msgtemplateconfigId+1,'Document Submission Application Owner',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Document Submission Application Owner',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Applicant - Document Upload','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;DOC_SUBMISSION_APP_OWNER_APPLICANT_OWNER&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Please note that applicant- <strong> $recipientData[&quot;DOC_SUBMISSION_APP_OWNER_APPLICANT_ID&quot;]- $recipientData[&quot;DOC_SUBMISSION_APP_OWNER_APPLICANT_NAME&quot;]</strong> has uploaded a document - <strong><b> $recipientData[&quot;DOC_SUBMISSION_APP_OWNER_DOCUMENT_NAME&quot;]</b></strong> - for your review.</p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Applicant - Document Upload','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;DOC_SUBMISSION_APP_OWNER_APPLICANT_OWNER&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Please note that applicant- <strong> $recipientData[&quot;DOC_SUBMISSION_APP_OWNER_APPLICANT_ID&quot;]- $recipientData[&quot;DOC_SUBMISSION_APP_OWNER_APPLICANT_NAME&quot;]</strong> has uploaded a document - <strong><b> $recipientData[&quot;DOC_SUBMISSION_APP_OWNER_DOCUMENT_NAME&quot;]</b></strong> - for your review.</p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

-- End Messaging for DOCUMENT_SUBMISSION_APPLICATION_OWNER Event
END IF; 

END $$
CALL V20221006154534__Create_DocSubmissionAppOwnerEvent () $$ 
DROP PROCEDURE IF EXISTS V20221006154534__Create_DocSubmissionAppOwnerEvent $$ 
DELIMITER ;