DELIMITER $$
DROP PROCEDURE IF EXISTS V20221123174057__Insert_FeePayer2DynamicDoc $$
CREATE PROCEDURE V20221123174057__Insert_FeePayer2DynamicDoc()
BEGIN

IF EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT MIN(dataProviderId) FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'FEE_PAYER_DETAILS_2', '7',null, '1', '0', 
"select fd.employerCompanyName AS EMPLOYER_COMPANY,
    fd.employerEmail AS EMPLOYER_EMAIL, T2.addressText AS ADDRESS, T5.countryName AS COUNTRY,
    T3.cityName AS CITY,T2.pincode AS PIN_CODE, fd.mobileNumber AS MOBILE_NO, fd.emailHome AS EMAIL_HOME
    from 
    fee_payer_detail fd 
     left outer join 
    students st on st.personId = fd.personId
	 left outer join
    admission a on a.studentId = st.userId
        LEFT OUTER JOIN 
    salutations T1 ON T1.id = fd.salutationId
        LEFT JOIN
    address T2 ON T2.id = fd.addressId
        LEFT OUTER JOIN
    city T3 ON T3.id = T2.cityId
     LEFT OUTER JOIN
    country_region T4 ON T4.id = T3.countryRegionId
        LEFT OUTER JOIN
    country T5 ON T5.id= T4.countryId", 
    'PRM_ADMISSION_ID', 
	'EMPLOYER_COMPANY, EMPLOYER_EMAIL, ADDRESS, COUNTRY, CITY, PIN_CODE, MOBILE_NO, EMAIL_HOME',
"where a.id=PRM_ADMISSION_ID and a.activeStatus=TRUE", '1');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('EMPLOYER_COMPANY', 'Employer Company',@dydtdatalinitemId+1),
('EMPLOYER_EMAIL', 'Email(Employer)',@dydtdatalinitemId+1),
('ADDRESS', 'Address',@dydtdatalinitemId+1),
('COUNTRY', 'Country',@dydtdatalinitemId+1),
('CITY', 'City',@dydtdatalinitemId+1),
('PIN_CODE', 'Postal Code',@dydtdatalinitemId+1),
('MOBILE_NO', 'Mobile Number',@dydtdatalinitemId+1),
('EMAIL_HOME', 'Email(Home)',@dydtdatalinitemId+1);
END IF; 

END $$
CALL V20221123174057__Insert_FeePayer2DynamicDoc() $$
DROP PROCEDURE IF EXISTS V20221123174057__Insert_FeePayer2DynamicDoc $$
DELIMITER ;