DELIMITER $$
DROP PROCEDURE IF EXISTS V20221212164844__Create_flag_color $$
CREATE PROCEDURE V20221212164844__Create_flag_color()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flag_color') THEN 
	CREATE TABLE IF NOT EXISTS `flag_color` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
		`itemCode` VARCHAR(255) NOT NULL,
		`itemValue` VARCHAR(255) NOT NULL,
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, 
		PRIMARY KEY (`id`),
		UNIQUE KEY `fk_flag_color_code_idx` (`itemCode`),
		FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
	INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
	VALUES (@standardMasterMaxId+1, NULL,'flag_color','FLAG_COLOR','SUNSuccess','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'code', 'FLAG_COLOR_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'value', 'FLAG_COLOR_NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

END IF; 

END $$
CALL V20221212164844__Create_flag_color () $$ 
DROP PROCEDURE IF EXISTS V20221212164844__Create_flag_color $$ 
DELIMITER ;