DELIMITER $$
DROP PROCEDURE IF EXISTS V20221220151647__Create_EvaluationGroupBillDetails $$
CREATE PROCEDURE V20221220151647__Create_EvaluationGroupBillDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='eval_group_bill_details')) THEN 
CREATE TABLE `eval_group_bill_details` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `evaluationGroupId` BIGINT NOT NULL,
  `admissionId` BIGINT NOT NULL,
  `billHeaderId` BIGINT NOT NULL,
  `evaluationGroupBillStatus` VARCHAR(45) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_egbd_evaluationGroupId_idx` (`evaluationGroupId` ASC) ,
  INDEX `fk_egbd_admissionId_idx` (`admissionId` ASC) ,
  INDEX `fk_egbd_billHeaderId_idx` (`billHeaderId` ASC) ,
  INDEX `fk_egbd_groupBill_lastUpdatedBy_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `fk_egbd_evaluationGroupId`
    FOREIGN KEY (`evaluationGroupId`)
    REFERENCES `evaluation_group` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_egbd_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_egbd_billHeaderId`
    FOREIGN KEY (`billHeaderId`)
    REFERENCES `bill_header` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_egbd_groupBill_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20221220151647__Create_EvaluationGroupBillDetails () $$ 
DROP PROCEDURE IF EXISTS V20221220151647__Create_EvaluationGroupBillDetails $$ 
DELIMITER ;