DELIMITER $$
DROP PROCEDURE IF EXISTS V20230216195811__Create_lpevenetDetails $$
CREATE PROCEDURE V20230216195811__Create_lpevenetDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='event_detail')) THEN
CREATE TABLE `event_detail` (
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `lpExamDetailId` BIGINT(20) NOT NULL,
 `weitage` VARCHAR(255) DEFAULT NULL,
 `lpTypeId` BIGINT(20) DEFAULT NULL,
  `lpAssessmentTransferredSkillId` BIGINT(20) DEFAULT NULL,
  `week` VARCHAR(255) DEFAULT NULL,
  `outcome` VARCHAR(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
   `lastUpdatedBy` bigint(20) NOT NULL,
 `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 INDEX `fk_lesson_plan_exam_detail_Id_idx` (`lpExamDetailId` ASC),
 INDEX `fk_lesson_plan_type_Id_idx` (`lpTypeId` ASC),
 INDEX `fk_lp_assessment_transferred_skill_Id_idx` (`lpAssessmentTransferredSkillId` ASC),
 INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
 CONSTRAINT `fk_lesson_plan_type_Id_id`
 FOREIGN KEY (`lpTypeId`)
REFERENCES `lession_planning_type` (`id`),
 CONSTRAINT `fk_lp_assessment_transferred_skill_Id_id`
 FOREIGN KEY (`lpAssessmentTransferredSkillId`)
REFERENCES `lesson_planning_assessment_transferred_skill` (`id`),
CONSTRAINT `fk_lesson_plan_exam_detail_Id_id`
 FOREIGN KEY (`lpExamDetailId`)
REFERENCES `lesson_plan_exam_detail` (`id`)      
ON DELETE RESTRICT
ON UPDATE RESTRICT);
END IF; 


END $$
CALL V20230216195811__Create_lpevenetDetails () $$ 
DROP PROCEDURE IF EXISTS V20230216195811__Create_lpevenetDetails $$ 
DELIMITER ;