DELIMITER $$
DROP PROCEDURE IF EXISTS V20230227172225__Create_Business_Attribute_Range $$
CREATE PROCEDURE V20230227172225__Create_Business_Attribute_Range()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_attribute_range')) THEN 
CREATE TABLE business_attribute_range (
  id bigint NOT NULL AUTO_INCREMENT,
  businessAttributeRuleId bigint NOT NULL,
  rangeFrom double NOT NULL,
  rangeTo double NOT NULL,
  score bigint NOT NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_businessAttributeRuleId_idx (businessAttributeRuleId),
  KEY fk_business_attribute_range_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_businessAttributeRule_businessAttributeRuleId FOREIGN KEY (businessAttributeRuleId) REFERENCES business_attribute_rule (id),
  CONSTRAINT fk_business_attribute_range_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20230227172225__Create_Business_Attribute_Range () $$ 
DROP PROCEDURE IF EXISTS V20230227172225__Create_Business_Attribute_Range $$ 
DELIMITER ;